/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.util;

import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmxUtils {
    private static final Logger logger = LoggerFactory.getLogger(JmxUtils.class);
    private static boolean initialized;
    private static final List<String> OPERATING_SYSTEM_BEAN_CLASS_NAMES;
    @Nullable
    private static Class<?> operatingSystemBeanClass;

    @Nullable
    public static synchronized Method getOperatingSystemMBeanMethod(OperatingSystemMXBean operatingSystemBean, String methodName) {
        if (!initialized) {
            JmxUtils.init();
        }
        if (operatingSystemBeanClass == null) {
            return null;
        }
        try {
            operatingSystemBeanClass.cast(operatingSystemBean);
            return operatingSystemBeanClass.getMethod(methodName, new Class[0]);
        }
        catch (ClassCastException | NoSuchMethodException | SecurityException e) {
            return null;
        }
    }

    private static void init() {
        try {
            for (String className : OPERATING_SYSTEM_BEAN_CLASS_NAMES) {
                try {
                    operatingSystemBeanClass = Class.forName(className);
                    logger.info("Found JVM-specific OperatingSystemMXBean interface: {}", (Object)className);
                    break;
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
        }
        catch (Throwable throwable) {
            logger.error("Failed to load OperatingSystemMXBean implementation", throwable);
        }
        finally {
            initialized = true;
        }
    }

    static {
        OPERATING_SYSTEM_BEAN_CLASS_NAMES = Arrays.asList("com.ibm.lang.management.OperatingSystemMXBean", "com.sun.management.OperatingSystemMXBean");
    }
}

