/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.util;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;

public class CompletableFuture<V>
implements Future<V> {
    private final Object LOCK = new Object();
    @Nullable
    volatile V value;
    volatile boolean completed = false;
    volatile boolean cancelled = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (this.cancelled || this.completed) {
            return false;
        }
        Object object = this.LOCK;
        synchronized (object) {
            if (this.cancelled || this.completed) {
                return false;
            }
            this.cancelled = true;
            this.LOCK.notifyAll();
        }
        return true;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public boolean isDone() {
        return this.cancelled || this.completed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public V get() throws InterruptedException, ExecutionException {
        if (this.completed) {
            return this.value;
        }
        this.checkCancellation();
        Object object = this.LOCK;
        synchronized (object) {
            if (this.completed) {
                return this.value;
            }
            this.checkCancellation();
            this.LOCK.wait();
            this.checkCancellation();
            if (!this.completed) {
                throw new ExecutionException("Wait ended without being cancelled", new IllegalStateException("Future is not completed"));
            }
            return this.value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public V get(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        if (this.completed) {
            return this.value;
        }
        this.checkCancellation();
        Object object = this.LOCK;
        synchronized (object) {
            if (this.completed) {
                return this.value;
            }
            this.checkCancellation();
            this.LOCK.wait(unit.toMillis(timeout));
            this.checkCancellation();
            if (!this.completed) {
                throw new TimeoutException();
            }
            return this.value;
        }
    }

    private void checkCancellation() {
        if (this.cancelled) {
            throw new CancellationException("CompletableFuture has been cancelled before being completed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean complete(@Nullable V value) {
        if (this.cancelled || this.completed) {
            return false;
        }
        Object object = this.LOCK;
        synchronized (object) {
            if (this.cancelled || this.completed) {
                return false;
            }
            this.value = value;
            this.completed = true;
            this.LOCK.notifyAll();
            return true;
        }
    }
}

