/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.urlconnection;

import co.elastic.apm.agent.bci.TracerAwareInstrumentation;
import java.util.Collection;
import java.util.Collections;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class SSLContextInstrumentation
extends TracerAwareInstrumentation {
    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.named("javax.net.ssl.SSLContext").or(ElementMatchers.named("javax.net.SocketFactory")).or(ElementMatchers.named("javax.net.ssl.SSLSocketFactory"));
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("getDefault").and(ElementMatchers.isPublic()).and(ElementMatchers.isStatic()).and(ElementMatchers.takesArguments(0));
    }

    @Override
    public Collection<String> getInstrumentationGroupNames() {
        return Collections.singleton("ssl-context");
    }

    public static class AdviceClass {
        @Advice.OnMethodEnter(suppress=Throwable.class, skipOn=Advice.OnNonDefaultValue.class, inline=false)
        public static boolean skipExecutionIfAgentThread() {
            return Thread.currentThread().getName().startsWith("elastic-apm-");
        }
    }
}

