/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.tracemethods;

import co.elastic.apm.agent.bci.TracerAwareInstrumentation;
import co.elastic.apm.agent.bci.bytebuddy.CustomElementMatchers;
import co.elastic.apm.agent.bci.bytebuddy.SimpleMethodSignatureOffsetMappingFactory;
import co.elastic.apm.agent.configuration.CoreConfiguration;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.GlobalTracer;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.matcher.MethodMatcher;
import co.elastic.apm.agent.matcher.WildcardMatcher;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.NamedElement;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class TraceMethodInstrumentation
extends TracerAwareInstrumentation {
    private final MethodMatcher methodMatcher;
    private final CoreConfiguration config;

    public TraceMethodInstrumentation(ElasticApmTracer tracer, MethodMatcher methodMatcher) {
        this.methodMatcher = methodMatcher;
        this.config = tracer.getConfig(CoreConfiguration.class);
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return CustomElementMatchers.matches(this.methodMatcher.getClassMatcher()).and(ElementMatchers.not(CustomElementMatchers.isProxy())).and(this.methodMatcher.getAnnotationMatcher()).and(ElementMatchers.declaresMethod(CustomElementMatchers.matches(this.methodMatcher.getMethodMatcher())));
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        ElementMatcher.Junction<NamedElement> matcher = CustomElementMatchers.matches(this.methodMatcher.getMethodMatcher());
        final List<WildcardMatcher> methodsExcludedFromInstrumentation = this.config.getMethodsExcludedFromInstrumentation();
        if (!methodsExcludedFromInstrumentation.isEmpty()) {
            matcher = matcher.and(ElementMatchers.not(new ElementMatcher<MethodDescription>(){

                @Override
                public boolean matches(MethodDescription target) {
                    return WildcardMatcher.anyMatch(methodsExcludedFromInstrumentation, target.getActualName()) != null;
                }
            }));
        }
        if (this.methodMatcher.getModifier() != null) {
            switch (this.methodMatcher.getModifier()) {
                case 1: {
                    matcher = matcher.and(ElementMatchers.isPublic());
                    break;
                }
                case 4: {
                    matcher = matcher.and(ElementMatchers.isProtected());
                    break;
                }
                case 2: {
                    matcher = matcher.and(ElementMatchers.isPrivate());
                }
            }
        }
        if (this.methodMatcher.getArgumentMatchers() != null) {
            matcher = matcher.and(ElementMatchers.takesArguments(this.methodMatcher.getArgumentMatchers().size()));
            List<WildcardMatcher> argumentMatchers = this.methodMatcher.getArgumentMatchers();
            for (int i = 0; i < argumentMatchers.size(); ++i) {
                matcher = matcher.and(ElementMatchers.takesArgument(i, CustomElementMatchers.matches(argumentMatchers.get(i))));
            }
        }
        return matcher.and(ElementMatchers.not(ElementMatchers.isConstructor())).and(ElementMatchers.not(ElementMatchers.isAbstract())).and(ElementMatchers.not(ElementMatchers.isNative())).and(ElementMatchers.not(ElementMatchers.isSynthetic())).and(ElementMatchers.not(ElementMatchers.isTypeInitializer()));
    }

    @Override
    public Collection<String> getInstrumentationGroupNames() {
        return Collections.singletonList("method-matching");
    }

    @Override
    public String getAdviceClassName() {
        return this.getClass().getName() + "$TraceMethodAdvice";
    }

    public static class TraceMethodAdvice {
        private static final ElasticApmTracer tracer = GlobalTracer.requireTracerImpl();
        private static final long traceMethodThresholdMicros;

        @Nullable
        @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
        public static Object onMethodEnter(@Advice.Origin Class<?> clazz, @SimpleMethodSignatureOffsetMappingFactory.SimpleMethodSignature String signature) {
            Transaction span = null;
            AbstractSpan<?> parent = tracer.getActive();
            if (parent == null) {
                span = tracer.startRootTransaction(clazz.getClassLoader());
                if (span != null) {
                    ((AbstractSpan)span.withName(signature)).activate();
                }
            } else if (parent.isSampled()) {
                span = ((Span)parent.createSpan().withName(signature)).activate();
            }
            return span;
        }

        @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class, inline=false)
        public static void onMethodExit(@Advice.Enter @Nullable Object spanObj, @Advice.Thrown @Nullable Throwable t) {
            AbstractSpan span = (AbstractSpan)spanObj;
            if (span != null) {
                span.captureException(t);
                long endTime = span.getTraceContext().getClock().getEpochMicros();
                if (span instanceof Span) {
                    long durationMicros = endTime - span.getTimestamp();
                    if (traceMethodThresholdMicros > 0L && durationMicros < traceMethodThresholdMicros && t == null) {
                        span.requestDiscarding();
                    }
                }
                ((AbstractSpan)span.deactivate()).end(endTime);
            }
        }

        static {
            CoreConfiguration config = tracer.getConfig(CoreConfiguration.class);
            traceMethodThresholdMicros = config.getTraceMethodsDurationThreshold().getMillis() * 1000L;
        }
    }
}

