/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.springwebflux;

import co.elastic.apm.agent.cache.WeakKeySoftValueLoadingCache;
import co.elastic.apm.agent.impl.transaction.Transaction;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.server.reactive.AbstractServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.server.ServerWebExchange;

public class WebfluxServletHelper {
    private static final Logger logger = LoggerFactory.getLogger(WebfluxServletHelper.class);
    private static final MethodHandle NOOP = MethodHandles.constant(String.class, "ClassLoader cannot load Servlets");
    private static final WeakKeySoftValueLoadingCache<Class<?>, MethodHandle> getAttributeMethodHandle = new WeakKeySoftValueLoadingCache(new WeakKeySoftValueLoadingCache.ValueSupplier<Class<?>, MethodHandle>(){

        @Override
        @Nullable
        public MethodHandle get(Class<?> klass) {
            try {
                return MethodHandles.lookup().findVirtual(klass, "getAttribute", MethodType.methodType(Object.class, String.class));
            }
            catch (Exception e) {
                logger.debug("Class {} does not implement Servlet API", (Object)klass);
                return NOOP;
            }
        }
    });

    @Nullable
    public static Transaction getServletTransaction(ServerWebExchange exchange) {
        Transaction transaction = null;
        ServerHttpRequest exchangeRequest = exchange.getRequest();
        if (exchangeRequest instanceof AbstractServerHttpRequest) {
            Object nativeRequest = ((AbstractServerHttpRequest)exchangeRequest).getNativeRequest();
            transaction = (Transaction)WebfluxServletHelper.getServletAttribute(nativeRequest, "co.elastic.apm.agent.servlet.ServletApiAdvice.transaction");
        }
        return transaction;
    }

    @Nullable
    private static Object getServletAttribute(Object nativeRequest, String name) {
        MethodHandle methodHandle = getAttributeMethodHandle.get(nativeRequest.getClass());
        if (methodHandle == null || methodHandle == NOOP) {
            return null;
        }
        try {
            return methodHandle.invoke(nativeRequest, name);
        }
        catch (Throwable thrown) {
            logger.error("unable to get servlet attribute", thrown);
            return null;
        }
    }
}

