/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.springwebflux;

import co.elastic.apm.agent.impl.GlobalTracer;
import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.springwebflux.WebFluxInstrumentation;
import java.lang.reflect.Type;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.ResolvableType;

public class BodyInsertersInstrumentation
extends WebFluxInstrumentation {
    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.named("org.springframework.web.reactive.function.BodyInserters");
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("fromPublisher").or(ElementMatchers.named("fromProducer")).and(ElementMatchers.takesArgument(1, Class.class).or(ElementMatchers.takesArgument(1, ElementMatchers.named("org.springframework.core.ParameterizedTypeReference"))));
    }

    @Override
    public String getAdviceClassName() {
        return "co.elastic.apm.agent.springwebflux.BodyInsertersInstrumentation$OnEnterAdvice";
    }

    public static class OnEnterAdvice {
        @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
        public static void onEnter(@Advice.Argument(value=1) @Nullable Object arg) {
            Transaction transaction;
            if (arg == null) {
                return;
            }
            ResolvableType type = null;
            if (arg instanceof ParameterizedTypeReference) {
                type = ResolvableType.forType((Type)((ParameterizedTypeReference)arg).getType());
            } else if (arg instanceof Class) {
                type = ResolvableType.forClass((Class)((Class)arg));
            }
            if (type == null) {
                return;
            }
            if (type.getType().getTypeName().equals("org.springframework.http.codec.ServerSentEvent") && (transaction = GlobalTracer.get().currentTransaction()) != null) {
                transaction.ignoreTransaction();
            }
        }
    }
}

