/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.sparkjava;

import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.GlobalTracer;
import co.elastic.apm.agent.impl.context.web.WebConfiguration;
import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.util.TransactionNameUtils;
import co.elastic.apm.agent.util.VersionUtils;
import net.bytebuddy.asm.Advice;
import spark.Route;
import spark.routematch.RouteMatch;

public class RoutesAdvice {
    private static final ElasticApmTracer tracer = GlobalTracer.requireTracerImpl();

    @Advice.OnMethodExit(suppress=Throwable.class, inline=false)
    public static void onExitFind(@Advice.Return RouteMatch routeMatch) {
        Transaction transaction = tracer.currentTransaction();
        if (transaction == null || routeMatch == null) {
            return;
        }
        String method = routeMatch.getHttpMethod().name().toUpperCase();
        TransactionNameUtils.setNameFromHttpRequestPath(method, routeMatch.getMatchUri(), transaction.getAndOverrideName(11), tracer.getConfig(WebConfiguration.class).getUrlGroups());
        transaction.setFrameworkName("Spark");
        transaction.setFrameworkVersion(VersionUtils.getVersion(Route.class, "com.sparkjava", "spark-core"));
    }
}

