/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.servlet.helper;

import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.Tracer;
import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.objectpool.Allocator;
import co.elastic.apm.agent.objectpool.ObjectPool;
import co.elastic.apm.agent.objectpool.impl.QueueBasedObjectPool;
import co.elastic.apm.agent.servlet.ServletTransactionHelper;
import co.elastic.apm.agent.servlet.helper.AsyncConstants;
import co.elastic.apm.agent.servlet.helper.AsyncContextAdviceHelper;
import co.elastic.apm.agent.servlet.helper.JavaxApmAsyncListener;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncListener;
import javax.servlet.ServletRequest;
import org.jctools.queues.atomic.AtomicQueueFactory;
import org.jctools.queues.spec.ConcurrentQueueSpec;

public class JavaxAsyncContextAdviceHelper
implements AsyncContextAdviceHelper<AsyncContext> {
    private final ObjectPool<JavaxApmAsyncListener> asyncListenerObjectPool;
    private final ServletTransactionHelper servletTransactionHelper;
    private final Tracer tracer;

    public JavaxAsyncContextAdviceHelper(ElasticApmTracer tracer) {
        this.tracer = tracer;
        this.servletTransactionHelper = new ServletTransactionHelper(tracer);
        this.asyncListenerObjectPool = QueueBasedObjectPool.ofRecyclable(AtomicQueueFactory.newQueue(ConcurrentQueueSpec.createBoundedMpmc(256)), false, new ApmAsyncListenerAllocator());
    }

    ServletTransactionHelper getServletTransactionHelper() {
        return this.servletTransactionHelper;
    }

    @Override
    public void onExitStartAsync(AsyncContext asyncContext) {
        ServletRequest request = asyncContext.getRequest();
        if (request.getAttribute(AsyncConstants.ASYNC_LISTENER_ADDED) != null) {
            return;
        }
        Transaction transaction = this.tracer.currentTransaction();
        if (transaction != null && transaction.isSampled() && request.getAttribute(AsyncConstants.ASYNC_LISTENER_ADDED) == null) {
            request.setAttribute(AsyncConstants.ASYNC_LISTENER_ADDED, (Object)Boolean.TRUE);
            asyncContext.addListener((AsyncListener)this.asyncListenerObjectPool.createInstance().withTransaction(transaction), asyncContext.getRequest(), asyncContext.getResponse());
            request.setAttribute(ServletTransactionHelper.ASYNC_ATTRIBUTE, (Object)Boolean.TRUE);
            request.setAttribute(ServletTransactionHelper.TRANSACTION_ATTRIBUTE, (Object)transaction);
        }
    }

    void recycle(JavaxApmAsyncListener apmAsyncListener) {
        this.asyncListenerObjectPool.recycle(apmAsyncListener);
    }

    private final class ApmAsyncListenerAllocator
    implements Allocator<JavaxApmAsyncListener> {
        private ApmAsyncListenerAllocator() {
        }

        @Override
        public JavaxApmAsyncListener createInstance() {
            return new JavaxApmAsyncListener(JavaxAsyncContextAdviceHelper.this);
        }
    }
}

