/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.servlet;

import co.elastic.apm.agent.servlet.JavaxUtil;
import co.elastic.apm.agent.servlet.ServletVersionInstrumentation;
import javax.annotation.Nullable;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import net.bytebuddy.asm.Advice;

public abstract class JavaxServletVersionInstrumentation
extends ServletVersionInstrumentation {
    private static String getServletVersionTypeMatcherClassName() {
        return "javax.servlet.Servlet";
    }

    private static String getRootClassNameThatClassloaderCanLoad() {
        return "javax.servlet.AsyncContext";
    }

    public static class JavaxService
    extends ServletVersionInstrumentation.Service {
        @Override
        public String rootClassNameThatClassloaderCanLoad() {
            return JavaxServletVersionInstrumentation.getRootClassNameThatClassloaderCanLoad();
        }

        @Override
        String[] getServiceMethodArgumentClassNames() {
            return new String[]{"javax.servlet.ServletRequest", "javax.servlet.ServletResponse"};
        }

        @Override
        public String servletVersionTypeMatcherClassName() {
            return JavaxServletVersionInstrumentation.getServletVersionTypeMatcherClassName();
        }

        public static class AdviceClass {
            @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
            public static void onEnter(@Advice.This Servlet servlet) {
                ServletVersionInstrumentation.logServletVersion(JavaxUtil.getInfoFromServletContext(servlet.getServletConfig()));
            }
        }
    }

    public static class JavaxInit
    extends ServletVersionInstrumentation.Init {
        @Override
        public String servletVersionTypeMatcherClassName() {
            return JavaxServletVersionInstrumentation.getServletVersionTypeMatcherClassName();
        }

        @Override
        public String rootClassNameThatClassloaderCanLoad() {
            return JavaxServletVersionInstrumentation.getRootClassNameThatClassloaderCanLoad();
        }

        @Override
        String initMethodArgumentClassName() {
            return "javax.servlet.ServletConfig";
        }

        public static class AdviceClass {
            @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
            public static void onEnter(@Advice.Argument(value=0) @Nullable ServletConfig servletConfig) {
                ServletVersionInstrumentation.logServletVersion(JavaxUtil.getInfoFromServletContext(servletConfig));
            }
        }
    }
}

