/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.scheduled;

import co.elastic.apm.agent.bci.TracerAwareInstrumentation;
import co.elastic.apm.agent.bci.bytebuddy.CustomElementMatchers;
import co.elastic.apm.agent.bci.bytebuddy.SimpleMethodSignatureOffsetMappingFactory;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.stacktrace.StacktraceConfiguration;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.impl.transaction.Outcome;
import co.elastic.apm.agent.impl.transaction.Transaction;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScheduledTransactionNameInstrumentation
extends TracerAwareInstrumentation {
    public static final Logger logger = LoggerFactory.getLogger(ScheduledTransactionNameInstrumentation.class);
    private final Collection<String> applicationPackages;

    public ScheduledTransactionNameInstrumentation(ElasticApmTracer tracer) {
        this.applicationPackages = tracer.getConfig(StacktraceConfiguration.class).getApplicationPackages();
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return CustomElementMatchers.isInAnyPackage(this.applicationPackages, ElementMatchers.none()).and(ElementMatchers.declaresMethod(this.getMethodMatcher()));
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.isAnnotatedWith(ElementMatchers.namedOneOf("org.springframework.scheduling.annotation.Scheduled", "org.springframework.scheduling.annotation.Schedules", "javax.ejb.Schedule", "javax.ejb.Schedules", "jakarta.ejb.Schedule", "jakarta.ejb.Schedules"));
    }

    @Override
    public Collection<String> getInstrumentationGroupNames() {
        return Arrays.asList("concurrent", "scheduled");
    }

    @Override
    public String getAdviceClassName() {
        return this.getClass().getName() + "$ScheduledTransactionNameAdvice";
    }

    public static class ScheduledTransactionNameAdvice {
        @Nullable
        @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
        public static Object setTransactionName(@SimpleMethodSignatureOffsetMappingFactory.SimpleMethodSignature String signature, @Advice.Origin Class<?> clazz) {
            AbstractSpan<?> active = TracerAwareInstrumentation.tracer.getActive();
            if (active == null) {
                Transaction transaction = TracerAwareInstrumentation.tracer.startRootTransaction(clazz.getClassLoader());
                if (transaction != null) {
                    ((Transaction)transaction.withName(signature)).withType("scheduled").activate();
                    return transaction;
                }
            } else {
                logger.debug("Not creating transaction for method {} because there is already a transaction running ({})", (Object)signature, (Object)active);
            }
            return null;
        }

        @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class, inline=false)
        public static void onMethodExit(@Advice.Enter @Nullable Object transactionObj, @Advice.Thrown @Nullable Throwable t) {
            if (transactionObj instanceof Transaction) {
                Transaction transaction = (Transaction)transactionObj;
                ((Transaction)((Transaction)((Transaction)transaction.captureException(t)).withOutcome(t != null ? Outcome.FAILURE : Outcome.SUCCESS)).deactivate()).end();
            }
        }
    }
}

