/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.report.serialize;

import co.elastic.apm.agent.context.AbstractLifecycleListener;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.metrics.Labels;
import co.elastic.apm.agent.metrics.MetricRegistry;
import co.elastic.apm.agent.metrics.MetricSet;
import co.elastic.apm.agent.report.Reporter;
import co.elastic.apm.agent.report.ReporterConfiguration;
import co.elastic.apm.agent.report.serialize.MetricRegistrySerializer;
import com.dslplatform.json.JsonWriter;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class MetricRegistryReporter
extends AbstractLifecycleListener
implements MetricRegistry.MetricsReporter,
Runnable {
    private final Reporter reporter;
    private final ElasticApmTracer tracer;
    private final MetricRegistry metricRegistry;
    private final MetricRegistrySerializer serializer;

    public MetricRegistryReporter(ElasticApmTracer tracer) {
        this.tracer = tracer;
        this.reporter = tracer.getReporter();
        this.metricRegistry = tracer.getMetricRegistry();
        this.serializer = new MetricRegistrySerializer();
    }

    @Override
    public void start(ElasticApmTracer tracer) {
        long intervalMs = tracer.getConfig(ReporterConfiguration.class).getMetricsIntervalMs();
        if (intervalMs > 0L) {
            tracer.getSharedSingleThreadedPool().scheduleAtFixedRate(this, intervalMs, intervalMs, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public void run() {
        this.metricRegistry.flipPhaseAndReport(this);
    }

    @Override
    public void stop() throws Exception {
        this.tracer.getSharedSingleThreadedPool().submit(this);
    }

    @Override
    public void report(Map<? extends Labels, MetricSet> metricSets) {
        if (this.tracer.isRunning()) {
            List<String> serviceNames = this.tracer.getServiceNameOverrides();
            for (MetricSet metricSet : metricSets.values()) {
                JsonWriter jw = this.serializer.serialize(metricSet, serviceNames);
                if (jw == null) continue;
                this.reporter.report(jw);
            }
        }
    }
}

