/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.rabbitmq;

import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.rabbitmq.MessageBatchIteratorWrapper;
import co.elastic.apm.agent.rabbitmq.SpringAmqpTransactionHelper;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.springframework.amqp.core.Message;

public class MessageBatchListWrapper
implements List<Message> {
    private final List<Message> delegate;
    private final ElasticApmTracer tracer;
    private final SpringAmqpTransactionHelper transactionHelper;

    public MessageBatchListWrapper(List<Message> delegate, ElasticApmTracer tracer, SpringAmqpTransactionHelper transactionHelper) {
        this.delegate = delegate;
        this.tracer = tracer;
        this.transactionHelper = transactionHelper;
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.delegate.contains(o);
    }

    @Override
    public Iterator<Message> iterator() {
        return new MessageBatchIteratorWrapper(this.delegate.iterator(), this.tracer, this.transactionHelper);
    }

    @Override
    public Object[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.delegate.toArray(a);
    }

    @Override
    public boolean add(Message message) {
        return this.delegate.add(message);
    }

    @Override
    public boolean remove(Object o) {
        return this.delegate.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.delegate.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends Message> c) {
        return this.delegate.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends Message> c) {
        return this.delegate.addAll(index, c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.delegate.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.delegate.retainAll(c);
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public boolean equals(Object o) {
        return this.delegate.equals(o);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public Message get(int index) {
        return this.delegate.get(index);
    }

    @Override
    public Message set(int index, Message element) {
        return this.delegate.set(index, element);
    }

    @Override
    public void add(int index, Message element) {
        this.delegate.add(index, element);
    }

    @Override
    public Message remove(int index) {
        return this.delegate.remove(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.delegate.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.delegate.lastIndexOf(o);
    }

    @Override
    public ListIterator<Message> listIterator() {
        return this.delegate.listIterator();
    }

    @Override
    public ListIterator<Message> listIterator(int index) {
        return this.delegate.listIterator(index);
    }

    @Override
    public List<Message> subList(int fromIndex, int toIndex) {
        return new MessageBatchListWrapper(this.delegate.subList(fromIndex, toIndex), this.tracer, this.transactionHelper);
    }
}

