/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.quartzjob;

import co.elastic.apm.agent.bci.TracerAwareInstrumentation;
import co.elastic.apm.agent.bci.bytebuddy.CustomElementMatchers;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.GlobalTracer;
import co.elastic.apm.agent.impl.stacktrace.StacktraceConfiguration;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.impl.transaction.Outcome;
import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.quartzjob.JobExecutionContextHandler;
import co.elastic.apm.agent.util.VersionUtils;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nullable;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJobTransactionNameInstrumentation
extends TracerAwareInstrumentation {
    public static final String TRANSACTION_TYPE = "scheduled";
    public static final String INSTRUMENTATION_TYPE = "quartz";
    private final Collection<String> applicationPackages;

    protected AbstractJobTransactionNameInstrumentation(ElasticApmTracer tracer) {
        this.applicationPackages = tracer.getConfig(StacktraceConfiguration.class).getApplicationPackages();
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return CustomElementMatchers.isInAnyPackage(this.applicationPackages, ElementMatchers.none()).or(ElementMatchers.nameStartsWith("org.quartz.job")).and(ElementMatchers.hasSuperType(ElementMatchers.named("org.quartz.Job"))).and(ElementMatchers.declaresMethod(this.getMethodMatcher()));
    }

    @Override
    public Collection<String> getInstrumentationGroupNames() {
        return Collections.singletonList(INSTRUMENTATION_TYPE);
    }

    static class BaseAdvice {
        private static final Logger logger = LoggerFactory.getLogger(BaseAdvice.class);

        BaseAdvice() {
        }

        @Nullable
        protected static <T> Transaction createAndActivateTransaction(@Nullable T jobExecutionContext, String signature, Class<?> clazz, JobExecutionContextHandler<T> helper) {
            Transaction transaction = null;
            AbstractSpan<?> active = GlobalTracer.get().getActive();
            if (active == null) {
                String transactionName = null;
                if (jobExecutionContext != null) {
                    transactionName = helper.getJobDetailKey(jobExecutionContext);
                }
                if (transactionName != null) {
                    transaction = BaseAdvice.createAndActivateTransaction(clazz, transactionName);
                } else {
                    logger.warn("Cannot correctly name transaction for method {} because JobExecutionContext is null or lacking job details", (Object)signature);
                    transaction = BaseAdvice.createAndActivateTransaction(clazz, signature);
                }
            } else {
                logger.debug("Not creating transaction for method {} because there is already a transaction running ({})", (Object)signature, (Object)active);
            }
            return transaction;
        }

        protected static <T> void endTransaction(@Nullable T jobExecutionContext, @Nullable Object transactionObj, @Nullable Throwable t, JobExecutionContextHandler<T> helper) {
            if (transactionObj instanceof Transaction) {
                Object result;
                Transaction transaction = (Transaction)transactionObj;
                if (jobExecutionContext != null && (result = helper.getResult(jobExecutionContext)) != null) {
                    transaction.withResultIfUnset(result.toString());
                }
                ((Transaction)((Transaction)((Transaction)transaction.captureException(t)).withOutcome(t != null ? Outcome.FAILURE : Outcome.SUCCESS)).deactivate()).end();
            }
        }

        @Nullable
        private static Transaction createAndActivateTransaction(Class<?> originClass, String name) {
            Transaction transaction = GlobalTracer.get().startRootTransaction(originClass.getClassLoader());
            if (transaction != null) {
                ((Transaction)transaction.withName(name)).withType(AbstractJobTransactionNameInstrumentation.TRANSACTION_TYPE).activate();
                transaction.setFrameworkName("Quartz");
                transaction.setFrameworkVersion(VersionUtils.getVersion(JobExecutionContext.class, "org.quartz-scheduler", AbstractJobTransactionNameInstrumentation.INSTRUMENTATION_TYPE));
            }
            return transaction;
        }
    }
}

