/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.profiler;

import co.elastic.apm.agent.context.AbstractLifecycleListener;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.profiler.FixedNanoClock;
import co.elastic.apm.agent.profiler.NanoClock;
import co.elastic.apm.agent.profiler.ProfilingActivationListener;
import co.elastic.apm.agent.profiler.SamplingProfiler;
import co.elastic.apm.agent.profiler.SystemNanoClock;

public class ProfilingFactory
extends AbstractLifecycleListener {
    private final SamplingProfiler profiler;
    private final NanoClock nanoClock;

    public ProfilingFactory(ElasticApmTracer tracer) {
        boolean envTest = false;
        if (!$assertionsDisabled) {
            envTest = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        this.nanoClock = envTest ? new FixedNanoClock() : new SystemNanoClock();
        this.profiler = new SamplingProfiler(tracer, this.nanoClock);
    }

    @Override
    public void start(ElasticApmTracer tracer) {
        this.profiler.start(tracer);
        tracer.registerSpanListener(new ProfilingActivationListener(tracer, this.profiler));
    }

    @Override
    public void stop() throws Exception {
        this.profiler.stop();
    }

    public SamplingProfiler getProfiler() {
        return this.profiler;
    }

    public NanoClock getNanoClock() {
        return this.nanoClock;
    }
}

