/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.profiler;

import co.elastic.apm.agent.configuration.converter.ListValueConverter;
import co.elastic.apm.agent.configuration.converter.TimeDuration;
import co.elastic.apm.agent.configuration.converter.TimeDurationValueConverter;
import co.elastic.apm.agent.configuration.validation.RangeValidator;
import co.elastic.apm.agent.matcher.WildcardMatcher;
import co.elastic.apm.agent.matcher.WildcardMatcherValueConverter;
import java.util.Arrays;
import java.util.List;
import org.stagemonitor.configuration.ConfigurationOption;
import org.stagemonitor.configuration.ConfigurationOptionProvider;

public class ProfilingConfiguration
extends ConfigurationOptionProvider {
    private static final String PROFILING_CATEGORY = "Profiling";
    private final ConfigurationOption<Boolean> profilingEnabled = ConfigurationOption.booleanOption().key("profiling_inferred_spans_enabled").configurationCategory("Profiling").description("Set to `true` to make the agent create spans for method executions based on\nhttps://github.com/jvm-profiling-tools/async-profiler[async-profiler], a sampling aka statistical profiler.\n\nDue to the nature of how sampling profilers work,\nthe duration of the inferred spans are not exact, but only estimations.\nThe <<config-profiling-inferred-spans-sampling-interval, `profiling_inferred_spans_sampling_interval`>> lets you fine tune the trade-off between accuracy and overhead.\n\nThe inferred spans are created after a profiling session has ended.\nThis means there is a delay between the regular and the inferred spans being visible in the UI.\n\nNOTE: This feature is not available on Windows and on OpenJ9").dynamic(true).tags("added[1.15.0]", "experimental").buildWithDefault(false);
    private final ConfigurationOption<Boolean> backupDiagnosticFiles = ConfigurationOption.booleanOption().key("profiling_inferred_spans_backup_diagnostic_files").configurationCategory("Profiling").dynamic(true).tags("added[1.15.0]", "internal").buildWithDefault(false);
    private final ConfigurationOption<Integer> asyncProfilerSafeMode = ConfigurationOption.integerOption().key("async_profiler_safe_mode").configurationCategory("Profiling").dynamic(false).description("Can be used for analysis: the Async Profiler's area that deals with recovering stack trace frames \nis known to be sensitive in some systems. It is used as a bit mask using values are between 0 and 31, \nwhere 0 enables all recovery attempts and 31 disables all five (corresponding 1, 2, 4, 8 and 16).").tags("internal").buildWithDefault(0);
    private final ConfigurationOption<Boolean> postProcessingEnabled = ConfigurationOption.booleanOption().key("profiling_inferred_spans_post_processing_enabled").configurationCategory("Profiling").dynamic(true).description("Can be used to test the effect of the async-profiler in isolation from the agent's post-processing.").tags("added[1.18.0]", "internal").buildWithDefault(true);
    private final ConfigurationOption<TimeDuration> samplingInterval = TimeDurationValueConverter.durationOption("ms").key("profiling_inferred_spans_sampling_interval").configurationCategory("Profiling").dynamic(true).description("The frequency at which stack traces are gathered within a profiling session.\nThe lower you set it, the more accurate the durations will be.\nThis comes at the expense of higher overhead and more spans for potentially irrelevant operations.\nThe minimal duration of a profiling-inferred span is the same as the value of this setting.").addValidator(RangeValidator.isInRange(TimeDuration.of("1ms"), TimeDuration.of("1s"))).tags("added[1.15.0]").buildWithDefault(TimeDuration.of("50ms"));
    private final ConfigurationOption<TimeDuration> inferredSpansMinDuration = TimeDurationValueConverter.durationOption("ms").key("profiling_inferred_spans_min_duration").configurationCategory("Profiling").dynamic(true).description("The minimum duration of an inferred span.\nNote that the min duration is also implicitly set by the sampling interval.\nHowever, increasing the sampling interval also decreases the accuracy of the duration of inferred spans.").tags("added[1.15.0]").addValidator(RangeValidator.min(TimeDuration.of("0ms"))).buildWithDefault(TimeDuration.of("0ms"));
    private final ConfigurationOption<List<WildcardMatcher>> includedClasses = ConfigurationOption.builder(new ListValueConverter<WildcardMatcher>(new WildcardMatcherValueConverter()), List.class).key("profiling_inferred_spans_included_classes").configurationCategory("Profiling").description("If set, the agent will only create inferred spans for methods which match this list.\nSetting a value may slightly reduce overhead and can reduce clutter by only creating spans for the classes you are interested in.\nExample: `org.example.myapp.*`\n\nThis option supports the wildcard `*`, which matches zero or more characters.\nExamples: `/foo/*/bar/*/baz*`, `*foo*`.\nMatching is case insensitive by default.\nPrepending an element with `(?-i)` makes the matching case sensitive.").dynamic(true).tags("added[1.15.0]").buildWithDefault(WildcardMatcher.matchAllList());
    private final ConfigurationOption<List<WildcardMatcher>> excludedClasses = ConfigurationOption.builder(new ListValueConverter<WildcardMatcher>(new WildcardMatcherValueConverter()), List.class).key("profiling_inferred_spans_excluded_classes").configurationCategory("Profiling").description("Excludes classes for which no profiler-inferred spans should be created.\n\nThis option supports the wildcard `*`, which matches zero or more characters.\nExamples: `/foo/*/bar/*/baz*`, `*foo*`.\nMatching is case insensitive by default.\nPrepending an element with `(?-i)` makes the matching case sensitive.").dynamic(true).tags("added[1.15.0]").buildWithDefault(Arrays.asList(WildcardMatcher.caseSensitiveMatcher("java.*"), WildcardMatcher.caseSensitiveMatcher("javax.*"), WildcardMatcher.caseSensitiveMatcher("sun.*"), WildcardMatcher.caseSensitiveMatcher("com.sun.*"), WildcardMatcher.caseSensitiveMatcher("jdk.*"), WildcardMatcher.caseSensitiveMatcher("org.apache.tomcat.*"), WildcardMatcher.caseSensitiveMatcher("org.apache.catalina.*"), WildcardMatcher.caseSensitiveMatcher("org.apache.coyote.*"), WildcardMatcher.caseSensitiveMatcher("org.jboss.as.*"), WildcardMatcher.caseSensitiveMatcher("org.glassfish.*"), WildcardMatcher.caseSensitiveMatcher("org.eclipse.jetty.*"), WildcardMatcher.caseSensitiveMatcher("com.ibm.websphere.*"), WildcardMatcher.caseSensitiveMatcher("io.undertow.*")));
    private final ConfigurationOption<TimeDuration> profilerInterval = TimeDurationValueConverter.durationOption("s").key("profiling_inferred_spans_interval").description("The interval at which profiling sessions should be started.").configurationCategory("Profiling").addValidator(RangeValidator.min(TimeDuration.of("0ms"))).dynamic(true).tags("added[1.15.0]", "internal").buildWithDefault(TimeDuration.of("5s"));
    private final ConfigurationOption<TimeDuration> profilingDuration = TimeDurationValueConverter.durationOption("s").key("profiling_inferred_spans_duration").description("The duration of a profiling session.\nFor sampled transactions which fall within a profiling session (they start after and end before the session),\nso-called inferred spans will be created.\nThey appear in the trace waterfall view like regular spans.\n\nNOTE: It is not recommended to set much higher durations as it may fill the activation events file and async-profiler's frame buffer.\nWarnings will be logged if the activation events file is full.\nIf you want to have more profiling coverage, try decreasing <<config-profiling-inferred-spans-interval, `profiling_inferred_spans_interval`>>.").configurationCategory("Profiling").dynamic(true).addValidator(RangeValidator.isInRange(TimeDuration.of("1s"), TimeDuration.of("30s"))).tags("added[1.15.0]", "internal").buildWithDefault(TimeDuration.of("5s"));
    private final ConfigurationOption<String> profilerLibDirectory = ConfigurationOption.stringOption().key("profiling_inferred_spans_lib_directory").description("Profiling requires that the https://github.com/jvm-profiling-tools/async-profiler[async-profiler] shared library is exported to a temporary location and loaded by the JVM.\nThe partition backing this location must be executable, however in some server-hardened environments, `noexec` may be set on the standard `/tmp` partition, leading to `java.lang.UnsatisfiedLinkError` errors.\nSet this property to an alternative directory (e.g. `/var/tmp`) to resolve this.\nIf unset, the value of the `java.io.tmpdir` system property will be used.").configurationCategory("Profiling").dynamic(false).tags("added[1.18.0]").build();

    public boolean isProfilingEnabled() {
        return this.profilingEnabled.get();
    }

    public int getAsyncProfilerSafeMode() {
        return this.asyncProfilerSafeMode.get();
    }

    public TimeDuration getSamplingInterval() {
        return this.samplingInterval.get();
    }

    public TimeDuration getInferredSpansMinDuration() {
        return this.inferredSpansMinDuration.get();
    }

    public List<WildcardMatcher> getIncludedClasses() {
        return this.includedClasses.get();
    }

    public List<WildcardMatcher> getExcludedClasses() {
        return this.excludedClasses.get();
    }

    public TimeDuration getProfilingInterval() {
        return this.profilerInterval.get();
    }

    public TimeDuration getProfilingDuration() {
        return this.profilingDuration.get();
    }

    public boolean isNonStopProfiling() {
        return this.getProfilingDuration().getMillis() >= this.getProfilingInterval().getMillis();
    }

    public boolean isBackupDiagnosticFiles() {
        return this.backupDiagnosticFiles.get();
    }

    public String getProfilerLibDirectory() {
        return this.profilerLibDirectory.isDefault() ? System.getProperty("java.io.tmpdir") : this.profilerLibDirectory.get();
    }

    public boolean isPostProcessingEnabled() {
        return this.postProcessingEnabled.get();
    }
}

