/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.profiler;

import co.elastic.apm.agent.impl.ActivationListener;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.error.ErrorCapture;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.profiler.SamplingProfiler;
import java.util.Objects;

public class ProfilingActivationListener
implements ActivationListener {
    private final ElasticApmTracer tracer;
    private final SamplingProfiler profiler;

    public ProfilingActivationListener(ElasticApmTracer tracer) {
        this(tracer, Objects.requireNonNull(tracer.getLifecycleListener(SamplingProfiler.class)));
    }

    ProfilingActivationListener(ElasticApmTracer tracer, SamplingProfiler profiler) {
        this.tracer = tracer;
        this.profiler = profiler;
    }

    @Override
    public void beforeActivate(AbstractSpan<?> context) {
        if (context.isSampled()) {
            AbstractSpan<?> active = this.tracer.getActive();
            this.profiler.onActivation(context.getTraceContext(), active != null ? active.getTraceContext() : null);
        }
    }

    @Override
    public void beforeActivate(ErrorCapture error) {
    }

    @Override
    public void afterDeactivate(AbstractSpan<?> deactivatedContext) {
        if (deactivatedContext.isSampled()) {
            AbstractSpan<?> active = this.tracer.getActive();
            this.profiler.onDeactivation(deactivatedContext.getTraceContext(), active != null ? active.getTraceContext() : null);
        }
    }

    @Override
    public void afterDeactivate(ErrorCapture deactivatedError) {
    }
}

