/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.process;

import co.elastic.apm.agent.bci.TracerAwareInstrumentation;
import co.elastic.apm.agent.concurrent.JavaConcurrent;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.NamedElement;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class CommonsExecAsyncInstrumentation
extends TracerAwareInstrumentation {
    private static final String DEFAULT_EXECUTOR_CLASS = "org.apache.commons.exec.DefaultExecutor";
    private static final String DAEMON_EXECUTOR_CLASS = "org.apache.commons.exec.DaemonExecutor";

    @Override
    public ElementMatcher<? super NamedElement> getTypeMatcherPreFilter() {
        return ElementMatchers.nameContains("Executor");
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.named(DEFAULT_EXECUTOR_CLASS).or(ElementMatchers.named(DAEMON_EXECUTOR_CLASS)).or(ElementMatchers.hasSuperClass(ElementMatchers.named(DEFAULT_EXECUTOR_CLASS)));
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("createThread").and(ElementMatchers.takesArgument(0, Runnable.class));
    }

    @Override
    public Collection<String> getInstrumentationGroupNames() {
        return Arrays.asList("apache-commons-exec", "process");
    }

    @Override
    public String getAdviceClassName() {
        return "co.elastic.apm.agent.process.CommonsExecAsyncInstrumentation$CommonsExecAdvice";
    }

    public static final class CommonsExecAdvice {
        @Nullable
        @Advice.AssignReturned.ToArguments(value={@Advice.AssignReturned.ToArguments.ToArgument(value=0)})
        @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
        public static Runnable onEnter(Runnable runnable) {
            return JavaConcurrent.withContext(runnable, TracerAwareInstrumentation.tracer);
        }

        @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class, inline=false)
        public static void onExit(@Advice.Thrown Throwable thrown, @Advice.Argument(value=0) Runnable runnable) {
            JavaConcurrent.doFinally(thrown, runnable);
        }
    }
}

