/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.pluginapi;

import co.elastic.apm.agent.bci.TracerAwareInstrumentation;
import co.elastic.apm.agent.bci.bytebuddy.AnnotationValueOffsetMappingFactory;
import co.elastic.apm.agent.bci.bytebuddy.CustomElementMatchers;
import co.elastic.apm.agent.bci.bytebuddy.SimpleMethodSignatureOffsetMappingFactory;
import co.elastic.apm.agent.configuration.CoreConfiguration;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.stacktrace.StacktraceConfiguration;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.impl.transaction.Outcome;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.impl.transaction.Transaction;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class TracedInstrumentation
extends TracerAwareInstrumentation {
    private final CoreConfiguration coreConfig;
    private final StacktraceConfiguration stacktraceConfig;

    public TracedInstrumentation(ElasticApmTracer tracer) {
        this.coreConfig = tracer.getConfig(CoreConfiguration.class);
        this.stacktraceConfig = tracer.getConfig(StacktraceConfiguration.class);
    }

    @Override
    public ElementMatcher.Junction<ClassLoader> getClassLoaderMatcher() {
        return CustomElementMatchers.classLoaderCanLoadClass("co.elastic.apm.api.Traced");
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return CustomElementMatchers.isInAnyPackage(this.stacktraceConfig.getApplicationPackages(), ElementMatchers.none()).and(ElementMatchers.not(CustomElementMatchers.isProxy())).and(ElementMatchers.declaresMethod(this.getMethodMatcher()));
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        if (this.coreConfig.isEnablePublicApiAnnotationInheritance()) {
            return CustomElementMatchers.overridesOrImplementsMethodThat(ElementMatchers.isAnnotatedWith(ElementMatchers.named("co.elastic.apm.api.Traced")));
        }
        return ElementMatchers.isAnnotatedWith(ElementMatchers.named("co.elastic.apm.api.Traced"));
    }

    @Override
    public boolean includeWhenInstrumentationIsDisabled() {
        return false;
    }

    @Override
    public final Collection<String> getInstrumentationGroupNames() {
        return Arrays.asList("public-api", "annotations");
    }

    public static class AdviceClass {
        @Nullable
        @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
        public static Object onMethodEnter(@Advice.Origin Class<?> clazz, @SimpleMethodSignatureOffsetMappingFactory.SimpleMethodSignature String signature, @AnnotationValueOffsetMappingFactory.AnnotationValueExtractor(annotationClassName="co.elastic.apm.api.Traced", method="value") String spanName, @AnnotationValueOffsetMappingFactory.AnnotationValueExtractor(annotationClassName="co.elastic.apm.api.Traced", method="type") String type, @AnnotationValueOffsetMappingFactory.AnnotationValueExtractor(annotationClassName="co.elastic.apm.api.Traced", method="subtype") @Nullable String subtype, @AnnotationValueOffsetMappingFactory.AnnotationValueExtractor(annotationClassName="co.elastic.apm.api.Traced", method="action") @Nullable String action) {
            int namePriority;
            String name;
            AbstractSpan<?> parent = TracerAwareInstrumentation.tracer.getActive();
            if (parent != null) {
                return ((Span)parent.createSpan().withType(type.isEmpty() ? "app" : type).withSubtype(subtype).withAction(action).withName(spanName.isEmpty() ? signature : spanName)).activate();
            }
            Transaction transaction = TracerAwareInstrumentation.tracer.startRootTransaction(clazz.getClassLoader());
            if (transaction == null) {
                return null;
            }
            transaction.setFrameworkName("API");
            if (spanName.isEmpty()) {
                name = signature;
                namePriority = 100;
            } else {
                name = spanName;
                namePriority = 1000;
            }
            return ((Transaction)transaction.withName(name, namePriority)).withType(type.isEmpty() ? "request" : type).activate();
        }

        @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class, inline=false)
        public static void onMethodExit(@Advice.Enter @Nullable Object abstractSpan, @Advice.Thrown @Nullable Throwable t) {
            if (abstractSpan instanceof AbstractSpan) {
                ((AbstractSpan)((AbstractSpan)((AbstractSpan)((AbstractSpan)abstractSpan).captureException(t)).withOutcome(t != null ? Outcome.FAILURE : Outcome.SUCCESS)).deactivate()).end();
            }
        }
    }
}

