/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.log4j2;

import co.elastic.apm.agent.log.shader.AbstractEcsReformattingHelper;
import co.elastic.apm.agent.log.shader.Utils;
import co.elastic.logging.log4j2.EcsLayout;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.appender.AbstractOutputStreamAppender;
import org.apache.logging.log4j.core.appender.RollingRandomAccessFileAppender;
import org.apache.logging.log4j.core.appender.rolling.DefaultRolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.SizeBasedTriggeringPolicy;
import org.apache.logging.log4j.core.config.DefaultConfiguration;
import org.apache.logging.log4j.core.config.NullConfiguration;
import org.apache.logging.log4j.core.layout.AbstractLayout;
import org.apache.logging.log4j.core.util.KeyValuePair;

class Log4J2EcsReformattingHelper
extends AbstractEcsReformattingHelper<Appender, Layout<? extends Serializable>> {
    Log4J2EcsReformattingHelper() {
    }

    @Override
    @Nullable
    protected Layout<? extends Serializable> getFormatterFrom(Appender appender) {
        return appender.getLayout();
    }

    @Override
    protected String getAppenderName(Appender appender) {
        return appender.getName();
    }

    @Override
    protected Layout<? extends Serializable> createEcsFormatter(String eventDataset, @Nullable String serviceName, @Nullable String serviceNodeName, @Nullable Map<String, String> additionalFields, Layout<? extends Serializable> originalFormatter) {
        EcsLayout.Builder builder = EcsLayout.newBuilder().setServiceName(serviceName).setServiceNodeName(serviceNodeName).setEventDataset(eventDataset).setIncludeMarkers(true).setIncludeOrigin(false).setStackTraceAsArray(false);
        if (originalFormatter instanceof AbstractLayout) {
            builder.setConfiguration(((AbstractLayout)originalFormatter).getConfiguration());
        } else {
            builder.setConfiguration(new NullConfiguration());
        }
        if (additionalFields != null && !additionalFields.isEmpty()) {
            ArrayList<KeyValuePair> additionalFieldsList = new ArrayList<KeyValuePair>();
            for (Map.Entry<String, String> keyValuePair : additionalFields.entrySet()) {
                additionalFieldsList.add(new KeyValuePair(keyValuePair.getKey(), keyValuePair.getValue()));
            }
            builder.setAdditionalFields(additionalFieldsList.toArray(new KeyValuePair[0]));
        }
        return builder.build();
    }

    @Override
    @Nullable
    protected Appender createAndStartEcsAppender(Appender originalAppender, String ecsAppenderName, Layout<? extends Serializable> ecsFormatter) {
        RollingRandomAccessFileAppender ecsAppender = null;
        String logFile = null;
        String appenderClassName = originalAppender.getClass().getName();
        if (appenderClassName.equals("org.apache.logging.log4j.core.appender.FileAppender") || appenderClassName.equals("org.apache.logging.log4j.core.appender.RollingFileAppender") || appenderClassName.equals("org.apache.logging.log4j.core.appender.RandomAccessFileAppender") || appenderClassName.equals("org.apache.logging.log4j.core.appender.RollingRandomAccessFileAppender") || appenderClassName.equals("org.apache.logging.log4j.core.appender.MemoryMappedFileAppender")) {
            try {
                Method getFileNameMethod = originalAppender.getClass().getDeclaredMethod("getFileName", new Class[0]);
                logFile = (String)getFileNameMethod.invoke((Object)originalAppender, new Object[0]);
            }
            catch (Exception e) {
                this.logError("Failed to obtain log file name from file appender", e);
            }
        }
        if (logFile != null) {
            String shadeFile = Utils.computeShadeLogFilePath(logFile, this.getConfiguredShadeDir());
            DefaultRolloverStrategy rolloverStrategy = DefaultRolloverStrategy.createStrategy("1", "1", null, null, null, true, new DefaultConfiguration());
            SizeBasedTriggeringPolicy triggeringPolicy = SizeBasedTriggeringPolicy.createPolicy(String.valueOf(this.getMaxLogFileSize()));
            ecsAppender = RollingRandomAccessFileAppender.createAppender(shadeFile, shadeFile + ".%i", "true", ecsAppenderName, String.valueOf(((AbstractOutputStreamAppender)originalAppender).getImmediateFlush()), null, triggeringPolicy, rolloverStrategy, ecsFormatter, null, null, null, null, null);
            ecsAppender.start();
        }
        return ecsAppender;
    }

    @Override
    protected void setFormatter(Appender appender, Layout<? extends Serializable> layout) {
    }

    @Override
    protected void closeShadeAppender(Appender shadeAppender) {
        shadeAppender.stop();
    }
}

