/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.log.shipper;

import co.elastic.apm.agent.log.shipper.FileChangeListener;
import co.elastic.apm.agent.log.shipper.TailableFile;
import co.elastic.apm.agent.report.AbstractIntakeApiHandler;
import co.elastic.apm.agent.report.ApmServerClient;
import co.elastic.apm.agent.report.ReporterConfiguration;
import co.elastic.apm.agent.report.serialize.PayloadSerializer;
import com.dslplatform.json.JsonWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApmServerLogShipper
extends AbstractIntakeApiHandler
implements FileChangeListener {
    public static final String LOGS_ENDPOINT = "/intake/v2/logs";
    private static final Logger logger = LoggerFactory.getLogger(ApmServerLogShipper.class);
    private long httpRequestClosingThreshold;
    @Nullable
    private File currentFile;
    private Set<TailableFile> tailableFiles = new HashSet<TailableFile>();

    public ApmServerLogShipper(ApmServerClient apmServerClient, ReporterConfiguration reporterConfiguration, PayloadSerializer payloadSerializer) {
        super(reporterConfiguration, payloadSerializer, apmServerClient);
    }

    @Override
    public boolean onLineAvailable(TailableFile tailableFile, byte[] line, int offset, int length, boolean eol) throws Exception {
        this.tailableFiles.add(tailableFile);
        try {
            if (this.connection == null) {
                this.connection = this.startRequest(LOGS_ENDPOINT);
            }
            if (this.connection != null && this.os != null) {
                File file = tailableFile.getFile();
                if (!file.equals(this.currentFile)) {
                    this.currentFile = file;
                    this.writeFileMetadata(this.os, file);
                }
                this.write(this.os, line, offset, length, eol);
                return true;
            }
            logger.debug("Cannot establish connection to APM server, backing off log shipping.");
            this.onConnectionError(null, this.currentlyTransmitting, 0L);
        }
        catch (Exception e) {
            this.endRequest();
            if (this.shutDown) {
                throw e;
            }
            logger.error("Failed send log with this error: {}", (Object)e.getMessage());
            this.onConnectionError(null, this.currentlyTransmitting, 0L);
        }
        return false;
    }

    @Override
    protected void onRequestSuccess() {
        super.onRequestSuccess();
        for (TailableFile tailableFile : this.tailableFiles) {
            tailableFile.ack();
        }
    }

    @Override
    protected void onRequestError(Integer responseCode, InputStream inputStream, @Nullable IOException e) {
        super.onRequestError(responseCode, inputStream, e);
        for (TailableFile tailableFile : this.tailableFiles) {
            tailableFile.nak();
        }
    }

    private void writeFileMetadata(OutputStream os, File file) throws IOException {
        JsonWriter jw = this.payloadSerializer.getJsonWriter();
        jw.reset();
        this.payloadSerializer.serializeFileMetaData(file);
        os.write(jw.getByteBuffer(), 0, jw.size());
    }

    private void write(OutputStream os, byte[] line, int offset, int length, boolean eol) throws IOException {
        os.write(line, offset, length);
        if (eol) {
            ++this.currentlyTransmitting;
            os.write(10);
            if (this.shouldEndRequest()) {
                this.endRequest();
            }
        }
    }

    @Override
    @Nullable
    protected HttpURLConnection startRequest(String endpoint) throws Exception {
        HttpURLConnection connection = super.startRequest(endpoint);
        this.httpRequestClosingThreshold = System.currentTimeMillis() + this.reporterConfiguration.getApiRequestTime().getMillis();
        this.currentFile = null;
        return connection;
    }

    @Override
    public void onIdle() {
        if (this.shouldEndRequest()) {
            this.endRequest();
        }
    }

    @Override
    public void onShutdownInitiated() {
        this.close();
    }

    @Override
    public void onShutdownComplete() {
        this.endRequest();
    }

    @Override
    protected boolean shouldEndRequest() {
        return super.shouldEndRequest() || System.currentTimeMillis() > this.httpRequestClosingThreshold;
    }
}

