/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.log.shader;

import java.nio.file.Path;
import java.nio.file.Paths;
import javax.annotation.Nullable;

public class Utils {
    private static final String SHADE_FILE_EXTENSION = ".ecs.json";

    public static String computeShadeLogFilePath(String originalLogFile, @Nullable String configuredShadeFileDestinationDir) {
        Path originalFilePath = Paths.get(originalLogFile, new String[0]);
        Path logFileName = Paths.get(Utils.replaceFileExtensionToEcsJson(originalFilePath.getFileName().toString()), new String[0]);
        Path shadeDir = Utils.computeShadeLogsDir(originalFilePath, configuredShadeFileDestinationDir);
        if (shadeDir != null) {
            logFileName = shadeDir.resolve(logFileName);
        }
        return logFileName.toString();
    }

    @Nullable
    private static Path computeShadeLogsDir(Path originalFilePath, @Nullable String configuredShadeFileDestinationDir) {
        Path shadeDir;
        Path logsDir = originalFilePath.getParent();
        if (configuredShadeFileDestinationDir == null) {
            shadeDir = logsDir;
        } else {
            shadeDir = Paths.get(configuredShadeFileDestinationDir, new String[0]);
            if (!shadeDir.isAbsolute() && logsDir != null) {
                shadeDir = logsDir.resolve(shadeDir);
            }
        }
        return shadeDir;
    }

    static String replaceFileExtensionToEcsJson(String originalFileName) {
        int extensionIndex = originalFileName.lastIndexOf(46);
        if (extensionIndex > 0) {
            originalFileName = originalFileName.substring(0, extensionIndex);
        }
        return originalFileName.concat(SHADE_FILE_EXTENSION);
    }
}

