/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.lettuce;

import co.elastic.apm.agent.bci.TracerAwareInstrumentation;
import co.elastic.apm.agent.collections.WeakConcurrentProviderImpl;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.redis.RedisSpanUtils;
import co.elastic.apm.agent.sdk.weakconcurrent.WeakMap;
import io.lettuce.core.protocol.RedisCommand;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class Lettuce5StartSpanInstrumentation
extends TracerAwareInstrumentation {
    static final WeakMap<RedisCommand<?, ?, ?>, Span> commandToSpan = WeakConcurrentProviderImpl.createWeakSpanMap();

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.named("io.lettuce.core.RedisChannelHandler");
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("dispatch").and(ElementMatchers.returns(ElementMatchers.nameEndsWith("RedisCommand"))).and(ElementMatchers.takesArguments(1)).and(ElementMatchers.takesArgument(0, ElementMatchers.nameEndsWith("RedisCommand")));
    }

    @Override
    public Collection<String> getInstrumentationGroupNames() {
        return Arrays.asList("redis", "lettuce");
    }

    public static class AdviceClass {
        @Nullable
        @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
        public static Object beforeDispatch(@Nullable @Advice.Argument(value=0) RedisCommand<?, ?, ?> command) {
            Span span;
            if (command != null && (span = RedisSpanUtils.createRedisSpan(command.getType().name())) != null) {
                commandToSpan.put(command, span);
                return span;
            }
            return null;
        }

        @Advice.OnMethodExit(suppress=Throwable.class, inline=false)
        public static void afterDispatch(@Nullable @Advice.Enter Object spanObj) {
            Span span = (Span)spanObj;
            if (span != null) {
                span.deactivate();
            }
        }
    }
}

