/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.kafka.helper;

import javax.annotation.Nullable;
import org.apache.kafka.common.header.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ElasticHeaderImpl
implements Header {
    public static final Logger logger = LoggerFactory.getLogger(ElasticHeaderImpl.class);
    private final String key;
    @Nullable
    byte[] value;
    private long settingThreadId;

    public ElasticHeaderImpl(String key, int headerLength) {
        this.key = key;
        this.value = new byte[headerLength];
    }

    public String key() {
        return this.key;
    }

    @Nullable
    public byte[] valueForSetting() {
        this.settingThreadId = Thread.currentThread().getId();
        return this.value;
    }

    @Nullable
    public byte[] value() {
        if (Thread.currentThread().getId() != this.settingThreadId && this.value != null) {
            logger.warn("The assumption of same thread setting and serializing the header is invalid.");
            this.value = null;
        }
        return this.value;
    }
}

