/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.kafka;

import co.elastic.apm.agent.bci.TracerAwareInstrumentation;
import co.elastic.apm.agent.kafka.KafkaConsumerRecordsInstrumentation;
import co.elastic.apm.agent.kafka.helper.KafkaInstrumentationHeadersHelper;
import java.util.Iterator;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.apache.kafka.clients.consumer.ConsumerRecord;

public class ConsumerRecordsIteratorInstrumentation
extends KafkaConsumerRecordsInstrumentation {
    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("iterator").and(ElementMatchers.isPublic()).and(ElementMatchers.takesArguments(0)).and(ElementMatchers.returns(Iterator.class));
    }

    @Override
    public String getAdviceClassName() {
        return this.getClass().getName() + "$ConsumerRecordsAdvice";
    }

    public static class ConsumerRecordsAdvice {
        private static final KafkaInstrumentationHeadersHelper helper = KafkaInstrumentationHeadersHelper.get();

        @Nullable
        @Advice.AssignReturned.ToReturned
        @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class, inline=false)
        public static Iterator<ConsumerRecord<?, ?>> wrapIterator(@Advice.Return @Nullable Iterator<ConsumerRecord<?, ?>> iterator) {
            if (!TracerAwareInstrumentation.tracer.isRunning() || TracerAwareInstrumentation.tracer.currentTransaction() != null || iterator == null) {
                return iterator;
            }
            return helper.wrapConsumerRecordIterator(iterator);
        }
    }
}

