/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.jms;

import co.elastic.apm.agent.bci.TracerAwareInstrumentation;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.jms.BaseJmsInstrumentation;
import co.elastic.apm.agent.jms.JmsInstrumentationHelper;
import javax.annotation.Nullable;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmsMessageListenerInstrumentation
extends BaseJmsInstrumentation {
    public static final Logger logger = LoggerFactory.getLogger(JmsMessageListenerInstrumentation.class);

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.not(ElementMatchers.isInterface()).and(ElementMatchers.hasSuperType(ElementMatchers.named("javax.jms.MessageListener")));
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("onMessage").and(ElementMatchers.takesArgument(0, ElementMatchers.hasSuperType(ElementMatchers.named("javax.jms.Message")))).and(ElementMatchers.isPublic());
    }

    @Override
    public String getAdviceClassName() {
        return "co.elastic.apm.agent.jms.JmsMessageListenerInstrumentation$MessageListenerAdvice";
    }

    public static class MessageListenerAdvice
    extends BaseJmsInstrumentation.BaseAdvice {
        @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
        @Nullable
        public static Object beforeOnMessage(@Advice.Argument(value=0) @Nullable Message message, @Advice.Origin Class<?> clazz) {
            if (message == null || TracerAwareInstrumentation.tracer.currentTransaction() != null) {
                return null;
            }
            Destination destination = null;
            String destinationName = null;
            long timestamp = 0L;
            try {
                destination = message.getJMSDestination();
                timestamp = message.getJMSTimestamp();
            }
            catch (JMSException e) {
                logger.warn("Failed to retrieve message's destination", e);
            }
            if (destination != null && helper.ignoreDestination(destinationName = helper.extractDestinationName(message, destination))) {
                return null;
            }
            Transaction transaction = helper.startJmsTransaction(message, clazz);
            if (transaction != null) {
                transaction.withType(JmsInstrumentationHelper.MESSAGING_TYPE).withName(JmsInstrumentationHelper.RECEIVE_NAME_PREFIX);
                if (destinationName != null) {
                    helper.addDestinationDetails(destination, destinationName, (AbstractSpan<?>)transaction.appendToName(" from "));
                }
                helper.addMessageDetails(message, transaction);
                helper.setMessageAge(message, transaction);
                transaction.activate();
            }
            return transaction;
        }

        @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class, inline=false)
        public static void afterOnMessage(@Advice.Enter @Nullable Object transactionObj, @Advice.Thrown Throwable throwable) {
            if (transactionObj instanceof Transaction) {
                Transaction transaction = (Transaction)transactionObj;
                transaction.captureException(throwable);
                ((Transaction)transaction.deactivate()).end();
            }
        }
    }
}

