/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.jedis;

import co.elastic.apm.agent.bci.TracerAwareInstrumentation;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.redis.RedisSpanUtils;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.implementation.bytecode.assign.Assigner;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import redis.clients.jedis.BinaryJedis;

public class JedisInstrumentation
extends TracerAwareInstrumentation {
    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.named("redis.clients.jedis.Jedis").or(ElementMatchers.named("redis.clients.jedis.BinaryJedis"));
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.isMethod().and(ElementMatchers.isPublic()).and(ElementMatchers.isOverriddenFrom(ElementMatchers.nameEndsWith("Commands")).and(ElementMatchers.not(ElementMatchers.nameEndsWith("ClusterCommands"))));
    }

    @Override
    public Collection<String> getInstrumentationGroupNames() {
        return Arrays.asList("redis", "jedis");
    }

    public static class AdviceClass {
        @Nullable
        @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
        public static Object beforeSendCommand(@Advice.This(typing=Assigner.Typing.DYNAMIC) BinaryJedis thiz, @Advice.Origin(value="#m") String method) {
            Span span = RedisSpanUtils.createRedisSpan(method);
            if (span != null) {
                span.getContext().getDestination().withAddress(thiz.getClient().getHost()).withPort(thiz.getClient().getPort());
            }
            return span;
        }

        @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class, inline=false)
        public static void afterSendCommand(@Nullable @Advice.Enter Object spanObj, @Nullable @Advice.Thrown Throwable thrown) {
            Span span = (Span)spanObj;
            if (span != null) {
                ((Span)((Span)span.captureException(thrown)).deactivate()).end();
            }
        }
    }
}

