/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.jdbc;

import co.elastic.apm.agent.bci.TracerAwareInstrumentation;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.jdbc.JdbcInstrumentation;
import co.elastic.apm.agent.jdbc.helper.JdbcHelper;
import java.sql.PreparedStatement;
import java.sql.Statement;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.NamedElement;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public abstract class StatementInstrumentation
extends JdbcInstrumentation {
    private final ElementMatcher<? super MethodDescription> methodMatcher;

    StatementInstrumentation(ElementMatcher<? super MethodDescription> methodMatcher) {
        this.methodMatcher = methodMatcher;
    }

    @Override
    public ElementMatcher<? super NamedElement> getTypeMatcherPreFilter() {
        return ElementMatchers.nameContains("Statement").or(ElementMatchers.nameStartsWith("com.ibm.db2.jcc"));
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.not(ElementMatchers.isInterface()).and(ElementMatchers.hasSuperType(ElementMatchers.named("java.sql.Statement")));
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return this.methodMatcher;
    }

    public static class CloseStatementInstrumentation
    extends StatementInstrumentation {
        public CloseStatementInstrumentation(ElasticApmTracer tracer) {
            super(ElementMatchers.named("close").and(ElementMatchers.takesArguments(0)).and(ElementMatchers.isPublic()));
        }

        public static class AdviceClass {
            private static final JdbcHelper helper = JdbcHelper.get();

            @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
            public static void onBeforeClose(@Advice.This Statement statement) {
                if (statement instanceof PreparedStatement) {
                    helper.removeSqlForStatement(statement);
                }
            }
        }
    }

    public static class ExecutePreparedStatementInstrumentation
    extends StatementInstrumentation {
        public ExecutePreparedStatementInstrumentation(ElasticApmTracer tracer) {
            super(ElementMatchers.named("execute").or(ElementMatchers.named("executeQuery")).and(ElementMatchers.takesArguments(0)).and(ElementMatchers.isPublic()));
        }

        public static class AdviceClass {
            @Nullable
            @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
            public static Object onBeforeExecute(@Advice.This Statement statement) {
                JdbcHelper helper = JdbcHelper.get();
                String sql = helper.retrieveSqlForStatement(statement);
                return helper.createJdbcSpan(sql, statement, TracerAwareInstrumentation.tracer.getActive(), true);
            }

            @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class, inline=false)
            public static void onAfterExecute(@Advice.This Statement statement, @Advice.Enter @Nullable Object span, @Advice.Thrown @Nullable Throwable t) {
                if (span == null) {
                    return;
                }
                ((Span)((Span)((Span)span).captureException(t)).deactivate()).end();
            }
        }
    }

    public static class ExecuteUpdateNoQueryInstrumentation
    extends StatementInstrumentation {
        public ExecuteUpdateNoQueryInstrumentation(ElasticApmTracer tracer) {
            super(ElementMatchers.named("executeUpdate").or(ElementMatchers.named("executeLargeUpdate")).and(ElementMatchers.takesArguments(0)).and(ElementMatchers.isPublic()));
        }

        public static class AdviceClass {
            @Nullable
            @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
            public static Object onBeforeExecute(@Advice.This Statement statement) {
                JdbcHelper helper = JdbcHelper.get();
                String sql = helper.retrieveSqlForStatement(statement);
                return helper.createJdbcSpan(sql, statement, TracerAwareInstrumentation.tracer.getActive(), true);
            }

            @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class, inline=false)
            public static void onAfterExecute(@Advice.Enter @Nullable Object span, @Advice.Thrown @Nullable Throwable t, @Advice.Return long returnValue) {
                if (span == null) {
                    return;
                }
                if (t == null) {
                    ((Span)span).getContext().getDb().withAffectedRowsCount(returnValue);
                }
                ((Span)((Span)((Span)span).captureException(t)).deactivate()).end();
            }
        }
    }

    public static class ExecuteBatchInstrumentation
    extends StatementInstrumentation {
        public ExecuteBatchInstrumentation(ElasticApmTracer tracer) {
            super(ElementMatchers.named("executeBatch").or(ElementMatchers.named("executeLargeBatch")).and(ElementMatchers.takesArguments(0)).and(ElementMatchers.isPublic()));
        }

        public static class AdviceClass {
            @Nullable
            @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
            public static Object onBeforeExecute(@Advice.This Statement statement) {
                JdbcHelper helper = JdbcHelper.get();
                String sql = helper.retrieveSqlForStatement(statement);
                return helper.createJdbcSpan(sql, statement, TracerAwareInstrumentation.tracer.getActive(), true);
            }

            @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class, inline=false)
            public static void onAfterExecute(@Advice.Enter @Nullable Object spanObj, @Advice.Thrown @Nullable Throwable t, @Advice.Return @Nullable Object returnValue) {
                if (!(spanObj instanceof Span)) {
                    return;
                }
                Span span = (Span)spanObj;
                long affectedCount = 0L;
                if (returnValue instanceof int[]) {
                    int[] array = (int[])returnValue;
                    for (int i = 0; i < array.length; ++i) {
                        affectedCount += (long)array[i];
                    }
                } else if (returnValue instanceof long[]) {
                    long[] array = (long[])returnValue;
                    for (int i = 0; i < array.length; ++i) {
                        affectedCount += array[i];
                    }
                }
                span.getContext().getDb().withAffectedRowsCount(affectedCount);
                ((Span)((Span)span.captureException(t)).deactivate()).end();
            }
        }
    }

    public static class AddBatchInstrumentation
    extends StatementInstrumentation {
        public AddBatchInstrumentation(ElasticApmTracer tracer) {
            super(ElementMatchers.nameStartsWith("addBatch").and(ElementMatchers.takesArgument(0, String.class)).and(ElementMatchers.isPublic()));
        }

        public static class AdviceClass {
            @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
            public static void storeSql(@Advice.This Statement statement, @Advice.Argument(value=0) String sql) {
                JdbcHelper.get().mapStatementToSql(statement, sql);
            }
        }
    }

    public static class ExecuteUpdateWithQueryInstrumentation
    extends StatementInstrumentation {
        public ExecuteUpdateWithQueryInstrumentation(ElasticApmTracer tracer) {
            super(ElementMatchers.named("executeUpdate").or(ElementMatchers.named("executeLargeUpdate")).and(ElementMatchers.takesArgument(0, String.class)).and(ElementMatchers.isPublic()));
        }

        public static class AdviceClass {
            @Nullable
            @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
            public static Object onBeforeExecute(@Advice.This Statement statement, @Advice.Argument(value=0) String sql) {
                return JdbcHelper.get().createJdbcSpan(sql, statement, TracerAwareInstrumentation.tracer.getActive(), false);
            }

            @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class, inline=false)
            public static void onAfterExecute(@Advice.Enter @Nullable Object span, @Advice.Thrown @Nullable Throwable t, @Advice.Return long returnValue) {
                if (span == null) {
                    return;
                }
                if (t == null) {
                    ((Span)span).getContext().getDb().withAffectedRowsCount(returnValue);
                }
                ((Span)((Span)((Span)span).captureException(t)).deactivate()).end();
            }
        }
    }

    public static class ExecuteWithQueryInstrumentation
    extends StatementInstrumentation {
        public ExecuteWithQueryInstrumentation(ElasticApmTracer tracer) {
            super(ElementMatchers.named("execute").or(ElementMatchers.named("executeQuery")).and(ElementMatchers.takesArgument(0, String.class)).and(ElementMatchers.isPublic()));
        }

        public static class AdviceClass {
            @Nullable
            @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
            public static Object onBeforeExecute(@Advice.This Statement statement, @Advice.Argument(value=0) String sql) {
                return JdbcHelper.get().createJdbcSpan(sql, statement, TracerAwareInstrumentation.tracer.getActive(), false);
            }

            @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class, inline=false)
            public static void onAfterExecute(@Advice.This Statement statement, @Advice.Enter @Nullable Object span, @Advice.Thrown @Nullable Throwable t) {
                if (span == null) {
                    return;
                }
                ((Span)((Span)((Span)span).captureException(t)).deactivate()).end();
            }
        }
    }
}

