/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.impl.transaction;

import co.elastic.apm.agent.configuration.converter.RoundedDoubleConverter;
import co.elastic.apm.agent.objectpool.Recyclable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TraceState
implements Recyclable {
    private static final Logger log = LoggerFactory.getLogger(TraceState.class);
    private static final int DEFAULT_SIZE_LIMIT = 4096;
    private static final RoundedDoubleConverter DOUBLE_CONVERTER = RoundedDoubleConverter.withDefaultPrecision();
    private static final char VENDOR_SEPARATOR = ',';
    private static final char ENTRY_SEPARATOR = ';';
    private static final String VENDOR_PREFIX = "es=";
    private static final String SAMPLE_RATE_PREFIX = "s:";
    private static final String FULL_PREFIX = "es=s:";
    private int sizeLimit = 4096;
    private final StringBuilder rewriteBuffer;
    private final List<String> tracestate;
    private double sampleRate = Double.NaN;

    public TraceState() {
        this.tracestate = new ArrayList<String>(1);
        this.rewriteBuffer = new StringBuilder();
    }

    public void copyFrom(TraceState other) {
        this.sampleRate = other.sampleRate;
        this.sizeLimit = other.sizeLimit;
        this.tracestate.clear();
        for (int i = 0; i < other.tracestate.size(); ++i) {
            this.tracestate.add(other.tracestate.get(i));
        }
        this.rewriteBuffer.setLength(0);
    }

    public List<String> getTracestate() {
        return this.tracestate;
    }

    public void addTextHeader(String headerValue) {
        int sampleRateStart;
        int vendorStart = headerValue.indexOf(VENDOR_PREFIX);
        if (vendorStart < 0) {
            this.tracestate.add(headerValue);
            return;
        }
        int vendorEnd = headerValue.indexOf(44, vendorStart);
        if (vendorEnd < 0) {
            vendorEnd = headerValue.length();
        }
        if ((sampleRateStart = headerValue.indexOf(SAMPLE_RATE_PREFIX, vendorStart)) < 0) {
            log.warn("invalid header, no sample rate {}", (Object)headerValue);
            headerValue = this.rewriteRemoveInvalidHeader(headerValue, vendorStart, vendorEnd);
            if (headerValue.length() > 0) {
                this.tracestate.add(headerValue);
            }
            return;
        }
        int valueStart = sampleRateStart + 2;
        int valueEnd = valueStart;
        if (valueEnd < headerValue.length()) {
            char c = headerValue.charAt(valueEnd);
            while (valueEnd < headerValue.length() && c != ',' && c != ';') {
                c = headerValue.charAt(valueEnd++);
            }
            if (valueEnd < headerValue.length()) {
                --valueEnd;
            }
        }
        String headerValueString = headerValue.substring(valueStart, valueEnd);
        double value = Double.NaN;
        try {
            value = Double.parseDouble(headerValueString);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (Double.isNaN(value) || value < 0.0 || value > 1.0) {
            log.warn("invalid sample rate header {}", (Object)headerValueString);
            headerValue = this.rewriteRemoveInvalidHeader(headerValue, vendorStart, vendorEnd);
        } else if (!Double.isNaN(this.sampleRate)) {
            log.warn("sample rate already set to {}, trying to set it to {} through header will be ignored", (Object)this.sampleRate, (Object)value);
            headerValue = this.rewriteRemoveInvalidHeader(headerValue, vendorStart, vendorEnd);
        } else {
            double rounded = DOUBLE_CONVERTER.round(value);
            if (rounded != value) {
                headerValue = this.rewriteRoundedHeader(headerValue, valueStart, valueEnd, rounded);
                this.sampleRate = rounded;
            } else {
                this.sampleRate = value;
            }
        }
        if (!headerValue.isEmpty()) {
            this.tracestate.add(headerValue);
        }
    }

    private String rewriteRoundedHeader(String fullHeader, int valueStart, int valueEnd, double rounded) {
        this.rewriteBuffer.setLength(0);
        this.rewriteBuffer.append(fullHeader, 0, valueStart);
        this.rewriteBuffer.append(DOUBLE_CONVERTER.toString(rounded));
        this.rewriteBuffer.append(fullHeader, valueEnd, fullHeader.length());
        return this.rewriteBuffer.toString();
    }

    private String rewriteRemoveInvalidHeader(String fullHeader, int start, int end) {
        this.rewriteBuffer.setLength(0);
        if (start > 0) {
            this.rewriteBuffer.append(fullHeader, 0, start);
        }
        if (end < fullHeader.length()) {
            this.rewriteBuffer.append(fullHeader, end + 1, fullHeader.length());
        }
        return this.rewriteBuffer.toString();
    }

    public void set(double rate, String headerValue) {
        if (!Double.isNaN(this.sampleRate)) {
            throw new IllegalStateException(String.format("sample rate already set to %f, trying to set it to %f", this.sampleRate, rate));
        }
        this.sampleRate = rate;
        this.tracestate.add(headerValue);
    }

    public static String getHeaderValue(double sampleRate) {
        if (Double.isNaN(sampleRate) || sampleRate < 0.0 || sampleRate > 1.0) {
            throw new IllegalArgumentException("invalid sample rate " + sampleRate);
        }
        return FULL_PREFIX + DOUBLE_CONVERTER.toString(DOUBLE_CONVERTER.round(sampleRate));
    }

    public double getSampleRate() {
        return this.sampleRate;
    }

    @Nullable
    public String toTextHeader() {
        if (this.tracestate.isEmpty()) {
            return null;
        }
        return TextTracestateAppender.INSTANCE.join(this.tracestate, this.sizeLimit);
    }

    @Override
    public void resetState() {
        this.sampleRate = Double.NaN;
        this.sizeLimit = 4096;
        this.rewriteBuffer.setLength(0);
        this.tracestate.clear();
    }

    public void setSizeLimit(int limit) {
        if (!this.tracestate.isEmpty()) {
            throw new IllegalStateException("can't change size limit once headers have been added");
        }
        this.sizeLimit = limit;
    }

    private static class TextTracestateAppender {
        private static final TextTracestateAppender INSTANCE = new TextTracestateAppender();
        private final ThreadLocal<StringBuilder> tracestateBuffer = new ThreadLocal();

        private TextTracestateAppender() {
        }

        @Nullable
        public String join(List<String> tracestate, int tracestateSizeLimit) {
            String singleEntry;
            String string = singleEntry = tracestate.size() != 1 ? null : tracestate.get(0);
            if (singleEntry != null && singleEntry.length() <= tracestateSizeLimit) {
                return singleEntry;
            }
            StringBuilder buffer = this.getTracestateBuffer();
            int size = tracestate.size();
            for (int i = 0; i < size; ++i) {
                String value = tracestate.get(i);
                if (value == null) continue;
                this.appendTracestateHeaderValue(value, buffer, tracestateSizeLimit);
            }
            return buffer.length() == 0 ? null : buffer.toString();
        }

        void appendTracestateHeaderValue(String headerValue, StringBuilder tracestateBuffer, int tracestateSizeLimit) {
            boolean needsComma;
            int requiredLength = headerValue.length();
            boolean bl = needsComma = tracestateBuffer.length() > 0;
            if (needsComma) {
                ++requiredLength;
            }
            if (tracestateBuffer.length() + requiredLength <= tracestateSizeLimit) {
                if (needsComma) {
                    tracestateBuffer.append(',');
                }
                tracestateBuffer.append(headerValue);
            } else {
                int endIndex = 0;
                for (int i = headerValue.length() - 1; i >= 0; --i) {
                    if (headerValue.charAt(i) != ',' || tracestateBuffer.length() + i >= tracestateSizeLimit) continue;
                    endIndex = i;
                    break;
                }
                if (endIndex > 0) {
                    if (tracestateBuffer.length() > 0) {
                        tracestateBuffer.append(',');
                    }
                    tracestateBuffer.append(headerValue, 0, endIndex);
                }
            }
        }

        private StringBuilder getTracestateBuffer() {
            StringBuilder buffer = this.tracestateBuffer.get();
            if (buffer == null) {
                buffer = new StringBuilder();
                this.tracestateBuffer.set(buffer);
            } else {
                buffer.setLength(0);
            }
            return buffer;
        }
    }
}

