/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.impl.transaction;

import co.elastic.apm.agent.configuration.CoreConfiguration;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.context.Db;
import co.elastic.apm.agent.impl.context.Destination;
import co.elastic.apm.agent.impl.context.Message;
import co.elastic.apm.agent.impl.context.SpanContext;
import co.elastic.apm.agent.impl.context.Url;
import co.elastic.apm.agent.impl.context.web.ResultUtil;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.impl.transaction.Outcome;
import co.elastic.apm.agent.impl.transaction.SpanCount;
import co.elastic.apm.agent.impl.transaction.StackFrame;
import co.elastic.apm.agent.impl.transaction.TraceContext;
import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.objectpool.Recyclable;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Span
extends AbstractSpan<Span>
implements Recyclable {
    private static final Logger logger = LoggerFactory.getLogger(Span.class);
    public static final long MAX_LOG_INTERVAL_MICRO_SECS = TimeUnit.MINUTES.toMicros(5L);
    private static long lastSpanMaxWarningTimestamp;
    @Nullable
    private String type;
    @Nullable
    private String subtype;
    @Nullable
    private String action;
    private final SpanContext context = new SpanContext();
    @Nullable
    private Throwable stacktrace;
    @Nullable
    private AbstractSpan<?> parent;
    @Nullable
    private Transaction transaction;
    @Nullable
    private List<StackFrame> stackFrames;

    @Override
    public void setNonDiscardable() {
        if (this.isDiscardable()) {
            this.getTraceContext().setNonDiscardable();
            if (this.parent != null) {
                this.parent.setNonDiscardable();
            }
        }
    }

    public Span(ElasticApmTracer tracer) {
        super(tracer);
    }

    public <T> Span start(TraceContext.ChildContextCreator<T> childContextCreator, T parentContext, long epochMicros) {
        childContextCreator.asChildOf(this.traceContext, parentContext);
        if (parentContext instanceof Transaction) {
            this.parent = this.transaction = (Transaction)parentContext;
        } else if (parentContext instanceof Span) {
            Span parentSpan;
            this.parent = parentSpan = (Span)parentContext;
            this.transaction = parentSpan.transaction;
        }
        return this.start(epochMicros);
    }

    private Span start(long epochMicros) {
        if (this.transaction != null) {
            SpanCount spanCount = this.transaction.getSpanCount();
            if (this.transaction.isSpanLimitReached()) {
                if (epochMicros - lastSpanMaxWarningTimestamp > MAX_LOG_INTERVAL_MICRO_SECS) {
                    lastSpanMaxWarningTimestamp = epochMicros;
                    logger.warn("Max spans ({}) for transaction {} has been reached. For this transaction and possibly others, further spans will be dropped. See config param 'transaction_max_spans'.", (Object)this.tracer.getConfig(CoreConfiguration.class).getTransactionMaxSpans(), (Object)this.transaction);
                }
                logger.debug("Span exceeds transaction_max_spans {}", (Object)this);
                this.traceContext.setRecorded(false);
                spanCount.getDropped().incrementAndGet();
            }
            spanCount.getTotal().incrementAndGet();
        }
        if (epochMicros >= 0L) {
            this.setStartTimestamp(epochMicros);
        } else {
            this.setStartTimestampNow();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("startSpan {}", (Object)this);
            if (logger.isTraceEnabled()) {
                logger.trace("starting span at", new RuntimeException("this exception is just used to record where the span has been started from"));
            }
        }
        this.onAfterStart();
        return this;
    }

    @Override
    protected void onAfterStart() {
        super.onAfterStart();
        if (this.parent != null) {
            this.parent.incrementReferences();
            this.parent.onChildStart(this.getTimestamp());
        }
    }

    @Override
    public SpanContext getContext() {
        return this.context;
    }

    public Span withType(@Nullable String type) {
        this.type = Span.normalizeEmpty(type);
        return this;
    }

    public Span withSubtype(@Nullable String subtype) {
        this.subtype = Span.normalizeEmpty(subtype);
        return this;
    }

    public Span withAction(@Nullable String action) {
        this.action = Span.normalizeEmpty(action);
        return this;
    }

    @Nullable
    private static String normalizeEmpty(@Nullable String value) {
        return value == null || value.isEmpty() ? null : value;
    }

    @Deprecated
    public void setType(@Nullable String type, @Nullable String subtype, @Nullable String action) {
        String temp;
        int indexOfFirstDot;
        if (type != null && (subtype == null || subtype.isEmpty()) && (action == null || action.isEmpty()) && (indexOfFirstDot = (temp = type).indexOf(".")) > 0) {
            type = temp.substring(0, indexOfFirstDot);
            int indexOfSecondDot = temp.indexOf(".", indexOfFirstDot + 1);
            if (indexOfSecondDot > 0) {
                subtype = temp.substring(indexOfFirstDot + 1, indexOfSecondDot);
                if (indexOfSecondDot + 1 < temp.length()) {
                    action = temp.substring(indexOfSecondDot + 1);
                }
            }
        }
        this.withType(type);
        this.withSubtype(subtype);
        this.withAction(action);
    }

    @Nullable
    public Throwable getStacktrace() {
        return this.stacktrace;
    }

    @Nullable
    public String getType() {
        return this.type;
    }

    @Nullable
    public String getSubtype() {
        return this.subtype;
    }

    @Nullable
    public String getAction() {
        return this.action;
    }

    @Override
    public void beforeEnd(long epochMicros) {
        if (logger.isDebugEnabled()) {
            logger.debug("endSpan {}", (Object)this);
            if (logger.isTraceEnabled()) {
                logger.trace("ending span at", new RuntimeException("this exception is just used to record where the span has been ended from"));
            }
        }
        if (this.type == null) {
            this.type = "custom";
        }
        if (this.outcomeNotSet()) {
            Outcome outcome = this.context.getHttp().hasContent() ? ResultUtil.getOutcomeByHttpClientStatus(this.context.getHttp().getStatusCode()) : (this.hasCapturedExceptions() ? Outcome.FAILURE : Outcome.SUCCESS);
            this.withOutcome(outcome);
        }
        Destination.Service service = this.getContext().getDestination().getService();
        StringBuilder serviceResource = service.getResource();
        if (this.isExit() && serviceResource.length() == 0 && !service.isResourceSetByUser()) {
            String resourceType = this.subtype != null ? this.subtype : this.type;
            Db db = this.context.getDb();
            Message message = this.context.getMessage();
            Url internalUrl = this.context.getHttp().getInternalUrl();
            if (db.hasContent()) {
                serviceResource.append(resourceType);
                if (db.getInstance() != null) {
                    serviceResource.append('/').append(db.getInstance());
                }
            } else if (message.hasContent()) {
                serviceResource.append(resourceType);
                if (message.getQueueName() != null) {
                    serviceResource.append('/').append(message.getQueueName());
                }
            } else if (internalUrl.hasContent()) {
                serviceResource.append(internalUrl.getHostname());
                if (internalUrl.getPort() > 0) {
                    serviceResource.append(':').append(internalUrl.getPort());
                }
            } else {
                serviceResource.append(resourceType);
            }
        }
        if (this.transaction != null) {
            this.transaction.incrementTimer(this.type, this.subtype, this.getSelfDuration());
        }
        if (this.parent != null) {
            this.parent.onChildEnd(epochMicros);
            this.parent.decrementReferences();
        }
    }

    @Override
    protected void afterEnd() {
        this.tracer.endSpan(this);
    }

    @Override
    public void resetState() {
        super.resetState();
        this.context.resetState();
        this.stacktrace = null;
        this.type = null;
        this.subtype = null;
        this.action = null;
        this.parent = null;
        this.transaction = null;
        this.stackFrames = null;
    }

    public String toString() {
        return String.format("'%s' %s (%s)", this.name, this.traceContext, Integer.toHexString(System.identityHashCode(this)));
    }

    public Span withStacktrace(Throwable stacktrace) {
        this.stacktrace = stacktrace;
        return this;
    }

    @Override
    public void incrementReferences() {
        if (this.transaction != null) {
            this.transaction.incrementReferences();
        }
        super.incrementReferences();
    }

    @Override
    public void decrementReferences() {
        if (this.transaction != null) {
            this.transaction.decrementReferences();
        }
        super.decrementReferences();
    }

    @Override
    protected void recycle() {
        this.tracer.recycle(this);
    }

    @Override
    protected Span thiz() {
        return this;
    }

    public void setStackTrace(List<StackFrame> stackTrace) {
        this.stackFrames = stackTrace;
    }

    @Nullable
    public List<StackFrame> getStackFrames() {
        return this.stackFrames;
    }

    @Override
    @Nullable
    public Transaction getTransaction() {
        return this.transaction;
    }

    @Nullable
    public AbstractSpan<?> getParent() {
        return this.parent;
    }
}

