/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.impl.transaction;

import co.elastic.apm.agent.impl.transaction.AbstractHeaderGetter;
import co.elastic.apm.agent.impl.transaction.HeaderGetter;
import co.elastic.apm.agent.impl.transaction.HeaderRemover;
import co.elastic.apm.agent.impl.transaction.TextHeaderGetter;
import co.elastic.apm.agent.impl.transaction.TextHeaderSetter;
import co.elastic.apm.agent.util.PotentiallyMultiValuedMap;
import javax.annotation.Nullable;

public class MultiValueMapAccessor
extends AbstractHeaderGetter<String, PotentiallyMultiValuedMap>
implements TextHeaderGetter<PotentiallyMultiValuedMap>,
TextHeaderSetter<PotentiallyMultiValuedMap>,
HeaderRemover<PotentiallyMultiValuedMap> {
    public static final MultiValueMapAccessor INSTANCE = new MultiValueMapAccessor();

    private MultiValueMapAccessor() {
    }

    @Override
    @Nullable
    public String getFirstHeader(String headerName, PotentiallyMultiValuedMap headerMap) {
        return headerMap.getFirst(headerName);
    }

    @Override
    public <S> void forEach(String headerName, PotentiallyMultiValuedMap headerMap, S state, HeaderGetter.HeaderConsumer<String, S> consumer) {
        for (String headerValue : headerMap.getAll(headerName)) {
            consumer.accept(headerValue, state);
        }
    }

    @Override
    public void setHeader(String headerName, String headerValue, PotentiallyMultiValuedMap headerMap) {
        headerMap.add(headerName, headerValue);
    }

    @Override
    public void remove(String headerName, PotentiallyMultiValuedMap headerMap) {
        headerMap.removeIgnoreCase(headerName);
    }
}

