/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.impl.sampling;

import co.elastic.apm.agent.impl.sampling.Sampler;
import co.elastic.apm.agent.impl.transaction.Id;
import co.elastic.apm.agent.impl.transaction.TraceState;

public class ConstantSampler
implements Sampler {
    private static final Sampler TRUE = new ConstantSampler(true);
    private static final Sampler FALSE = new ConstantSampler(false);
    private final boolean decision;
    private final double rate;
    private final String traceStateHeader;

    private ConstantSampler(boolean decision) {
        this.decision = decision;
        this.rate = decision ? 1.0 : 0.0;
        this.traceStateHeader = TraceState.getHeaderValue(this.rate);
    }

    public static Sampler of(boolean decision) {
        if (decision) {
            return TRUE;
        }
        return FALSE;
    }

    @Override
    public boolean isSampled(Id traceId) {
        return this.decision;
    }

    @Override
    public double getSampleRate() {
        return this.rate;
    }

    @Override
    public String getTraceStateHeader() {
        return this.traceStateHeader;
    }
}

