/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.httpclient;

import co.elastic.apm.agent.bci.TracerAwareInstrumentation;
import co.elastic.apm.agent.bci.bytebuddy.CustomElementMatchers;
import co.elastic.apm.agent.http.client.HttpClientHelper;
import co.elastic.apm.agent.httpclient.BaseApacheHttpClientInstrumentation;
import co.elastic.apm.agent.httpclient.helper.RequestHeaderAccessor;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.impl.transaction.Outcome;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.impl.transaction.TraceContext;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.NamedElement;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.apache.http.client.CircularRedirectException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.conn.routing.HttpRoute;

public class ApacheHttpClientInstrumentation
extends BaseApacheHttpClientInstrumentation {
    @Override
    public String getAdviceClassName() {
        return "co.elastic.apm.agent.httpclient.ApacheHttpClientInstrumentation$ApacheHttpClientAdvice";
    }

    @Override
    public ElementMatcher.Junction<ClassLoader> getClassLoaderMatcher() {
        return ElementMatchers.not(ElementMatchers.isBootstrapClassLoader()).and(CustomElementMatchers.classLoaderCanLoadClass("org.apache.http.impl.execchain.ClientExecChain"));
    }

    @Override
    public ElementMatcher<? super NamedElement> getTypeMatcherPreFilter() {
        return ElementMatchers.nameContains("Exec").or(ElementMatchers.nameContains("Chain"));
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.hasSuperType(ElementMatchers.named("org.apache.http.impl.execchain.ClientExecChain"));
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("execute").and(ElementMatchers.takesArguments(4)).and(ElementMatchers.returns(ElementMatchers.hasSuperType(ElementMatchers.named("org.apache.http.client.methods.CloseableHttpResponse")))).and(ElementMatchers.takesArgument(0, ElementMatchers.hasSuperType(ElementMatchers.named("org.apache.http.conn.routing.HttpRoute")))).and(ElementMatchers.takesArgument(1, ElementMatchers.hasSuperType(ElementMatchers.named("org.apache.http.client.methods.HttpRequestWrapper")))).and(ElementMatchers.takesArgument(2, ElementMatchers.hasSuperType(ElementMatchers.named("org.apache.http.client.protocol.HttpClientContext")))).and(ElementMatchers.takesArgument(3, ElementMatchers.hasSuperType(ElementMatchers.named("org.apache.http.client.methods.HttpExecutionAware"))));
    }

    public static class ApacheHttpClientAdvice {
        @Nullable
        @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
        public static Object onBeforeExecute(@Advice.Argument(value=0) HttpRoute route, @Advice.Argument(value=1) HttpRequestWrapper request) {
            AbstractSpan<?> parent = TracerAwareInstrumentation.tracer.getActive();
            if (parent == null) {
                return null;
            }
            Span span = HttpClientHelper.startHttpClientSpan(parent, request.getMethod(), request.getURI(), route.getTargetHost().getHostName());
            if (span != null) {
                span.activate();
            }
            if (!TraceContext.containsTraceContextTextHeaders(request, RequestHeaderAccessor.INSTANCE)) {
                if (span != null) {
                    span.propagateTraceContext(request, RequestHeaderAccessor.INSTANCE);
                } else if (!TraceContext.containsTraceContextTextHeaders(request, RequestHeaderAccessor.INSTANCE)) {
                    parent.propagateTraceContext(request, RequestHeaderAccessor.INSTANCE);
                }
            }
            return span;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class, inline=false)
        public static void onAfterExecute(@Advice.Return @Nullable CloseableHttpResponse response, @Advice.Enter @Nullable Object spanObj, @Advice.Thrown @Nullable Throwable t) {
            Span span = (Span)spanObj;
            if (span == null) {
                return;
            }
            try {
                if (response != null && response.getStatusLine() != null) {
                    int statusCode = response.getStatusLine().getStatusCode();
                    span.getContext().getHttp().withStatusCode(statusCode);
                }
                span.captureException(t);
            }
            finally {
                if (t instanceof CircularRedirectException) {
                    span.withOutcome(Outcome.FAILURE);
                }
                ((Span)span.deactivate()).end();
            }
        }
    }
}

