/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.httpclient;

import co.elastic.apm.agent.bci.TracerAwareInstrumentation;
import co.elastic.apm.agent.bci.bytebuddy.CustomElementMatchers;
import co.elastic.apm.agent.httpclient.BaseApacheHttpClientInstrumentation;
import co.elastic.apm.agent.httpclient.helper.ApacheHttpAsyncClientHelper;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.impl.transaction.Span;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.NamedElement;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.implementation.bytecode.assign.Assigner;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;
import org.apache.http.protocol.HttpContext;

public class ApacheHttpAsyncClientInstrumentation
extends BaseApacheHttpClientInstrumentation {
    @Override
    public String getAdviceClassName() {
        return "co.elastic.apm.agent.httpclient.ApacheHttpAsyncClientInstrumentation$ApacheHttpAsyncClientAdvice";
    }

    @Override
    public ElementMatcher.Junction<ClassLoader> getClassLoaderMatcher() {
        return ElementMatchers.not(ElementMatchers.isBootstrapClassLoader()).and(CustomElementMatchers.classLoaderCanLoadClass("org.apache.http.nio.client.HttpAsyncClient"));
    }

    @Override
    public ElementMatcher<? super NamedElement> getTypeMatcherPreFilter() {
        return ElementMatchers.nameContains("HttpAsyncClient");
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.hasSuperType(ElementMatchers.named("org.apache.http.nio.client.HttpAsyncClient"));
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("execute").and(ElementMatchers.takesArguments(4)).and(ElementMatchers.takesArgument(0, ElementMatchers.named("org.apache.http.nio.protocol.HttpAsyncRequestProducer"))).and(ElementMatchers.takesArgument(1, ElementMatchers.named("org.apache.http.nio.protocol.HttpAsyncResponseConsumer"))).and(ElementMatchers.takesArgument(2, ElementMatchers.named("org.apache.http.protocol.HttpContext"))).and(ElementMatchers.takesArgument(3, ElementMatchers.named("org.apache.http.concurrent.FutureCallback")));
    }

    public static class ApacheHttpAsyncClientAdvice {
        private static ApacheHttpAsyncClientHelper asyncHelper = new ApacheHttpAsyncClientHelper();

        @Advice.AssignReturned.ToArguments(value={@Advice.AssignReturned.ToArguments.ToArgument(index=0, value=0, typing=Assigner.Typing.DYNAMIC), @Advice.AssignReturned.ToArguments.ToArgument(index=1, value=3, typing=Assigner.Typing.DYNAMIC)})
        @Nullable
        @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
        public static Object[] onBeforeExecute(@Advice.Argument(value=0) HttpAsyncRequestProducer requestProducer, @Advice.Argument(value=2) HttpContext context, @Advice.Argument(value=3) FutureCallback<?> futureCallback) {
            AbstractSpan<?> parent = TracerAwareInstrumentation.tracer.getActive();
            if (parent == null) {
                return null;
            }
            Span span = parent.createExitSpan();
            HttpAsyncRequestProducer wrappedProducer = requestProducer;
            FutureCallback<?> wrappedFutureCallback = futureCallback;
            boolean responseFutureWrapped = false;
            if (span != null) {
                span.withType("external").withSubtype("http").activate();
                wrappedProducer = asyncHelper.wrapRequestProducer(requestProducer, span, null);
                wrappedFutureCallback = asyncHelper.wrapFutureCallback(futureCallback, context, span);
                responseFutureWrapped = true;
            } else {
                wrappedProducer = asyncHelper.wrapRequestProducer(requestProducer, null, parent);
            }
            return new Object[]{wrappedProducer, wrappedFutureCallback, responseFutureWrapped, span};
        }

        @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class, inline=false)
        public static void onAfterExecute(@Advice.Enter @Nullable Object[] enter, @Advice.Thrown @Nullable Throwable t) {
            Span span;
            Span span2 = span = enter != null ? (Span)enter[3] : null;
            if (span != null) {
                span.deactivate();
                if (!((Boolean)enter[2]).booleanValue()) {
                    span.captureException(t);
                    span.end();
                }
            }
        }
    }
}

