/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.hibernatesearch.v5;

import co.elastic.apm.agent.bci.TracerAwareInstrumentation;
import co.elastic.apm.agent.bci.bytebuddy.CustomElementMatchers;
import co.elastic.apm.agent.hibernatesearch.HibernateSearchHelper;
import co.elastic.apm.agent.impl.transaction.Span;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.NamedElement;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.hibernate.search.query.hibernate.impl.FullTextQueryImpl;

public class HibernateSearch5Instrumentation
extends TracerAwareInstrumentation {
    @Override
    public String getAdviceClassName() {
        return "co.elastic.apm.agent.hibernatesearch.v5.HibernateSearch5Instrumentation$HibernateSearch5ExecuteAdvice";
    }

    @Override
    public ElementMatcher<? super NamedElement> getTypeMatcherPreFilter() {
        return ElementMatchers.nameContains("Query");
    }

    @Override
    public ElementMatcher.Junction<ClassLoader> getClassLoaderMatcher() {
        return ElementMatchers.not(ElementMatchers.isBootstrapClassLoader()).and(CustomElementMatchers.classLoaderCanLoadClass("org.hibernate.search.FullTextQuery"));
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.not(ElementMatchers.isInterface()).and(ElementMatchers.hasSuperType(ElementMatchers.named("org.hibernate.search.FullTextQuery")));
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("list").or(ElementMatchers.named("scroll")).or(ElementMatchers.named("iterate"));
    }

    @Override
    public Collection<String> getInstrumentationGroupNames() {
        return Collections.singleton("hibernate-search");
    }

    public static class HibernateSearch5ExecuteAdvice {
        @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
        public static Object onBeforeExecute(@Advice.This FullTextQueryImpl query, @Advice.Origin(value="#m") String methodName) {
            return HibernateSearchHelper.createAndActivateSpan(TracerAwareInstrumentation.tracer, methodName, query.getQueryString());
        }

        @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class, inline=false)
        public static void onAfterExecute(@Advice.Enter @Nullable Object span, @Advice.Thrown Throwable t) {
            if (span instanceof Span) {
                ((Span)((Span)((Span)span).captureException(t)).deactivate()).end();
            }
        }
    }
}

