/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.hibernatesearch;

import co.elastic.apm.agent.bci.TracerAwareInstrumentation;
import co.elastic.apm.agent.bci.bytebuddy.CustomElementMatchers;
import co.elastic.apm.agent.hibernatesearch.HibernateSearchHelper;
import co.elastic.apm.agent.impl.transaction.Span;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.NamedElement;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.hibernate.search.engine.search.query.SearchQuery;

public class HibernateSearch6Instrumentation
extends TracerAwareInstrumentation {
    @Override
    public String getAdviceClassName() {
        return "co.elastic.apm.agent.hibernatesearch.HibernateSearch6Instrumentation$Hibernate6ExecuteAdvice";
    }

    @Override
    public ElementMatcher<? super NamedElement> getTypeMatcherPreFilter() {
        return ElementMatchers.nameContains("Search");
    }

    @Override
    public ElementMatcher.Junction<ClassLoader> getClassLoaderMatcher() {
        return ElementMatchers.not(ElementMatchers.isBootstrapClassLoader()).and(CustomElementMatchers.classLoaderCanLoadClass("org.hibernate.search.engine.search.query.SearchQuery"));
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.not(ElementMatchers.isInterface()).and(ElementMatchers.hasSuperType(ElementMatchers.named("org.hibernate.search.engine.search.query.SearchQuery")));
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.nameStartsWith("fetch");
    }

    @Override
    public Collection<String> getInstrumentationGroupNames() {
        return Arrays.asList("hibernate-search", "experimental");
    }

    public static class Hibernate6ExecuteAdvice {
        @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
        public static Object onBeforeExecute(@Advice.This SearchQuery<?> query, @Advice.Origin(value="#m") String methodName) {
            return HibernateSearchHelper.createAndActivateSpan(TracerAwareInstrumentation.tracer, methodName, query.queryString());
        }

        @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class, inline=false)
        public static void onAfterExecute(@Advice.Enter @Nullable Object span, @Advice.Thrown @Nullable Throwable t) {
            if (span instanceof Span) {
                ((Span)((Span)((Span)span).captureException(t)).deactivate()).end();
            }
        }
    }
}

