/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.grpc;

import co.elastic.apm.agent.bci.TracerAwareInstrumentation;
import co.elastic.apm.agent.grpc.BaseInstrumentation;
import co.elastic.apm.agent.grpc.GrpcHelper;
import co.elastic.apm.agent.grpc.ServerCallInstrumentation;
import co.elastic.apm.agent.grpc.ServerCallListenerInstrumentation;
import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.sdk.DynamicTransformer;
import co.elastic.apm.agent.sdk.ElasticApmInstrumentation;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.NamedElement;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class ServerCallHandlerInstrumentation
extends BaseInstrumentation {
    private static final Collection<Class<? extends ElasticApmInstrumentation>> SERVER_CALL_INSTRUMENTATION = Collections.singletonList(ServerCallInstrumentation.class);
    private static final Collection<Class<? extends ElasticApmInstrumentation>> SERVER_CALL_LISTENER_INSTRUMENTATIONS = Arrays.asList(ServerCallListenerInstrumentation.OnCancel.class, ServerCallListenerInstrumentation.OnComplete.class, ServerCallListenerInstrumentation.OtherMethod.class);

    @Override
    public ElementMatcher<? super NamedElement> getTypeMatcherPreFilter() {
        return ElementMatchers.nameStartsWith("io.grpc");
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.hasSuperType(ElementMatchers.named("io.grpc.ServerCallHandler"));
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("startCall");
    }

    @Override
    public String getAdviceClassName() {
        return "co.elastic.apm.agent.grpc.ServerCallHandlerInstrumentation$ServerCallHandlerAdvice";
    }

    public static class ServerCallHandlerAdvice {
        @Nullable
        @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
        public static Object onEnter(@Advice.Origin Class<?> clazz, @Advice.Argument(value=0) ServerCall<?, ?> serverCall, @Advice.Argument(value=1) Metadata headers) {
            return GrpcHelper.getInstance().startTransaction(TracerAwareInstrumentation.tracer, clazz.getClassLoader(), serverCall, headers);
        }

        @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class, inline=false)
        public static void onExit(@Advice.Thrown @Nullable Throwable thrown, @Advice.Argument(value=0) ServerCall<?, ?> serverCall, @Advice.Return @Nullable ServerCall.Listener<?> listener, @Advice.Enter @Nullable Object enterTransaction) {
            if (!(enterTransaction instanceof Transaction)) {
                return;
            }
            Transaction transaction = (Transaction)enterTransaction;
            if (thrown != null) {
                ((Transaction)transaction.deactivate()).end();
                return;
            }
            if (listener != null) {
                DynamicTransformer.ensureInstrumented(serverCall.getClass(), SERVER_CALL_INSTRUMENTATION);
                DynamicTransformer.ensureInstrumented(listener.getClass(), SERVER_CALL_LISTENER_INSTRUMENTATIONS);
                GrpcHelper.getInstance().registerTransaction(serverCall, listener, transaction);
            }
        }
    }
}

