/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.grpc;

import co.elastic.apm.agent.grpc.BaseInstrumentation;
import co.elastic.apm.agent.grpc.ClientCallListenerInstrumentation;
import co.elastic.apm.agent.grpc.GrpcHelper;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.sdk.DynamicTransformer;
import co.elastic.apm.agent.sdk.ElasticApmInstrumentation;
import io.grpc.ClientCall;
import io.grpc.Metadata;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public abstract class ClientCallImplInstrumentation
extends BaseInstrumentation {
    private static final Collection<Class<? extends ElasticApmInstrumentation>> RESPONSE_LISTENER_INSTRUMENTATIONS = Arrays.asList(ClientCallListenerInstrumentation.Close.class, ClientCallListenerInstrumentation.OtherListenerMethod.class);

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.any();
    }

    public static class Cancel
    extends ClientCallImplInstrumentation {
        @Override
        public ElementMatcher<? super MethodDescription> getMethodMatcher() {
            return ElementMatchers.named("cancel").and(ElementMatchers.takesArgument(1, Throwable.class));
        }

        @Override
        public String getAdviceClassName() {
            return "co.elastic.apm.agent.grpc.ClientCallImplInstrumentation$Cancel$CancelAdvice";
        }

        public static class CancelAdvice {
            @Nullable
            @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
            public static void onEnter(@Advice.This ClientCall<?, ?> clientCall, @Advice.Argument(value=1) @Nullable Throwable cause) {
                GrpcHelper.getInstance().cancelCall(clientCall, cause);
            }
        }
    }

    public static class Start
    extends ClientCallImplInstrumentation {
        @Override
        public ElementMatcher<? super MethodDescription> getMethodMatcher() {
            return ElementMatchers.named("start");
        }

        @Override
        public String getAdviceClassName() {
            return "co.elastic.apm.agent.grpc.ClientCallImplInstrumentation$Start$StartAdvice";
        }

        public static class StartAdvice {
            @Nullable
            @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
            public static Object onEnter(@Advice.This ClientCall<?, ?> clientCall, @Advice.Argument(value=0) ClientCall.Listener<?> listener, @Advice.Argument(value=1) Metadata headers) {
                DynamicTransformer.ensureInstrumented(listener.getClass(), RESPONSE_LISTENER_INSTRUMENTATIONS);
                return GrpcHelper.getInstance().clientCallStartEnter(clientCall, listener, headers);
            }

            @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class, inline=false)
            public static void onExit(@Advice.Argument(value=0) ClientCall.Listener<?> listener, @Advice.Thrown @Nullable Throwable thrown, @Advice.Enter @Nullable Object span) {
                GrpcHelper.getInstance().clientCallStartExit((Span)span, listener, thrown);
            }
        }
    }
}

