/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.esrestclient.v6_4;

import co.elastic.apm.agent.esrestclient.ElasticsearchRestClientInstrumentation;
import co.elastic.apm.agent.esrestclient.ElasticsearchRestClientInstrumentationHelper;
import co.elastic.apm.agent.impl.transaction.Span;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.implementation.bytecode.assign.Assigner;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.ResponseListener;

public class ElasticsearchClientAsyncInstrumentation
extends ElasticsearchRestClientInstrumentation {
    @Override
    public String getAdviceClassName() {
        return this.getClass().getName() + "$ElasticsearchRestClientAsyncAdvice";
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.named("org.elasticsearch.client.RestClient");
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("performRequestAsync").and(ElementMatchers.takesArguments(2).and(ElementMatchers.takesArgument(0, ElementMatchers.named("org.elasticsearch.client.Request"))).and(ElementMatchers.takesArgument(1, ElementMatchers.named("org.elasticsearch.client.ResponseListener"))));
    }

    public static class ElasticsearchRestClientAsyncAdvice {
        private static final ElasticsearchRestClientInstrumentationHelper helper = ElasticsearchRestClientInstrumentationHelper.get();

        @Nullable
        @Advice.AssignReturned.ToArguments(value={@Advice.AssignReturned.ToArguments.ToArgument(index=1, value=1, typing=Assigner.Typing.DYNAMIC)})
        @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
        public static Object[] onBeforeExecute(@Advice.Argument(value=0) Request request, @Advice.Argument(value=1) ResponseListener responseListener) {
            Span span = helper.createClientSpan(request.getMethod(), request.getEndpoint(), request.getEntity());
            if (span != null) {
                Object[] ret = new Object[]{span, helper.wrapResponseListener(responseListener, span)};
                return ret;
            }
            return null;
        }

        @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class, inline=false)
        public static void onAfterExecute(@Advice.Thrown @Nullable Throwable t, @Advice.Enter @Nullable Object[] entryArgs) {
            Span span;
            if (entryArgs != null && (span = (Span)entryArgs[0]) != null) {
                span.deactivate();
            }
        }
    }
}

