/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.esrestclient.v5_6;

import co.elastic.apm.agent.esrestclient.ElasticsearchRestClientInstrumentation;
import co.elastic.apm.agent.esrestclient.ElasticsearchRestClientInstrumentationHelper;
import co.elastic.apm.agent.impl.transaction.Span;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.apache.http.HttpEntity;
import org.elasticsearch.client.Response;

public class ElasticsearchClientSyncInstrumentation
extends ElasticsearchRestClientInstrumentation {
    @Override
    public String getAdviceClassName() {
        return this.getClass().getName() + "$ElasticsearchRestClientAdvice";
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.named("org.elasticsearch.client.RestClient").and(ElementMatchers.not(ElementMatchers.declaresMethod(ElementMatchers.named("performRequest").and(ElementMatchers.takesArguments(1).and(ElementMatchers.takesArgument(0, ElementMatchers.named("org.elasticsearch.client.Request")))))));
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("performRequest").and(ElementMatchers.takesArguments(6).and(ElementMatchers.takesArgument(4, ElementMatchers.named("org.elasticsearch.client.HttpAsyncResponseConsumerFactory"))));
    }

    public static class ElasticsearchRestClientAdvice {
        private static final ElasticsearchRestClientInstrumentationHelper helper = ElasticsearchRestClientInstrumentationHelper.get();

        @Nullable
        @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
        public static Object onBeforeExecute(@Advice.Argument(value=0) String method, @Advice.Argument(value=1) String endpoint, @Advice.Argument(value=3) @Nullable HttpEntity entity) {
            return helper.createClientSpan(method, endpoint, entity);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class, inline=false)
        public static void onAfterExecute(@Advice.Return @Nullable Response response, @Advice.Enter @Nullable Object spanObj, @Advice.Thrown @Nullable Throwable t) {
            Span span = (Span)spanObj;
            if (span != null) {
                try {
                    helper.finishClientSpan(response, span, t);
                }
                finally {
                    span.deactivate();
                }
            }
        }
    }
}

