/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.errorlogging;

import co.elastic.apm.agent.bci.TracerAwareInstrumentation;
import co.elastic.apm.agent.impl.error.ErrorCapture;
import co.elastic.apm.agent.sdk.state.CallDepth;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.NamedElement;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public abstract class AbstractLoggerErrorCapturingInstrumentation
extends TracerAwareInstrumentation {
    @Override
    public String getAdviceClassName() {
        return "co.elastic.apm.agent.errorlogging.AbstractLoggerErrorCapturingInstrumentation$LoggingAdvice";
    }

    @Override
    public ElementMatcher<? super NamedElement> getTypeMatcherPreFilter() {
        return ElementMatchers.nameContains("Logger");
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("error").and(ElementMatchers.takesArgument(1, ElementMatchers.named("java.lang.Throwable")));
    }

    @Override
    public Collection<String> getInstrumentationGroupNames() {
        ArrayList<String> ret = new ArrayList<String>();
        ret.add("logging");
        return ret;
    }

    @Override
    public ElementMatcher.Junction<ClassLoader> getClassLoaderMatcher() {
        return ElementMatchers.not(ElementMatchers.ofType(ElementMatchers.nameStartsWith("co.elastic.apm.")));
    }

    public static class LoggingAdvice {
        private static final CallDepth callDepth = CallDepth.get(LoggingAdvice.class);

        @Nullable
        @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
        public static Object logEnter(@Advice.Argument(value=1) Throwable exception, @Advice.Origin Class<?> clazz) {
            if (!callDepth.isNestedCallAndIncrement()) {
                ErrorCapture error = TracerAwareInstrumentation.tracer.captureException(exception, TracerAwareInstrumentation.tracer.getActive(), clazz.getClassLoader());
                if (error != null) {
                    error.activate();
                }
                return error;
            }
            return null;
        }

        @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class, inline=false)
        public static void logExit(@Advice.Enter @Nullable Object errorCaptureObj) {
            callDepth.decrement();
            if (errorCaptureObj instanceof ErrorCapture) {
                ErrorCapture error = (ErrorCapture)errorCaptureObj;
                error.deactivate().end();
            }
        }
    }
}

