/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.dubbo;

import co.elastic.apm.agent.bci.TracerAwareInstrumentation;
import co.elastic.apm.agent.dubbo.AbstractAlibabaDubboInstrumentation;
import co.elastic.apm.agent.dubbo.AlibabaCallbackHolder;
import co.elastic.apm.agent.dubbo.AlibabaResponseCallbackInstrumentation;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.sdk.DynamicTransformer;
import co.elastic.apm.agent.sdk.ElasticApmInstrumentation;
import com.alibaba.dubbo.remoting.exchange.ResponseCallback;
import java.util.Arrays;
import java.util.List;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class AlibabaResponseFutureInstrumentation
extends AbstractAlibabaDubboInstrumentation {
    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.hasSuperType(ElementMatchers.named("com.alibaba.dubbo.remoting.exchange.ResponseFuture"));
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("setCallback");
    }

    @Override
    public String getAdviceClassName() {
        return "co.elastic.apm.agent.dubbo.AlibabaResponseFutureInstrumentation$AlibabaResponseFutureAdvice";
    }

    public static class AlibabaResponseFutureAdvice {
        private static final List<Class<? extends ElasticApmInstrumentation>> RESPONSE_CALLBACK_INSTRUMENTATIONS = Arrays.asList(AlibabaResponseCallbackInstrumentation.CaughtInstrumentation.class, AlibabaResponseCallbackInstrumentation.DoneInstrumentation.class);

        @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
        public static void onEnter(@Advice.Argument(value=0) ResponseCallback callback) {
            AbstractSpan<?> active = TracerAwareInstrumentation.tracer.getActive();
            if (active == null) {
                return;
            }
            AlibabaCallbackHolder.callbackSpanMap.put(callback, active);
            DynamicTransformer.ensureInstrumented(callback.getClass(), RESPONSE_CALLBACK_INSTRUMENTATIONS);
        }
    }
}

