/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.configuration;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.stagemonitor.configuration.source.AbstractConfigurationSource;
import org.stagemonitor.util.StringUtils;

public class AgentArgumentsConfigurationSource
extends AbstractConfigurationSource {
    private final Map<String, String> config;

    private AgentArgumentsConfigurationSource(Map<String, String> config) {
        this.config = config;
    }

    public static AgentArgumentsConfigurationSource parse(String agentAgruments) {
        HashMap<String, String> configs = new HashMap<String, String>();
        for (String config : StringUtils.split(agentAgruments, ';')) {
            int indexOfEquals = config.indexOf(61);
            if (indexOfEquals < 1) {
                throw new IllegalArgumentException(String.format("%s is not a '=' separated key/value pair", config));
            }
            configs.put(config.substring(0, indexOfEquals).trim(), config.substring(indexOfEquals + 1).trim());
        }
        return new AgentArgumentsConfigurationSource(configs);
    }

    @Override
    @Nullable
    public String getValue(String key) {
        return this.config.get(key);
    }

    @Override
    public String getName() {
        return "-javaagent options";
    }

    Map<String, String> getConfig() {
        return this.config;
    }
}

