/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.concurrent;

import co.elastic.apm.agent.bci.TracerAwareInstrumentation;
import co.elastic.apm.agent.concurrent.JavaConcurrent;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.ForkJoinTask;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class RunnableCallableForkJoinTaskInstrumentation
extends TracerAwareInstrumentation {
    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.hasSuperType(ElementMatchers.is(Runnable.class).or(ElementMatchers.is(Callable.class)).or(ElementMatchers.is(ForkJoinTask.class)));
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("run").and(ElementMatchers.takesArguments(0)).or(ElementMatchers.named("call").and(ElementMatchers.takesArguments(0))).or(ElementMatchers.named("exec").and(ElementMatchers.takesArguments(0).and(ElementMatchers.returns(Boolean.TYPE))));
    }

    @Override
    public Collection<String> getInstrumentationGroupNames() {
        return Arrays.asList("concurrent", "executor");
    }

    public static class AdviceClass {
        @Nullable
        @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
        public static Object onEnter(@Advice.This Object thiz) {
            return JavaConcurrent.restoreContext(thiz, TracerAwareInstrumentation.tracer);
        }

        @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class, inline=false)
        public static void onExit(@Advice.Thrown Throwable thrown, @Nullable @Advice.Enter Object context) {
            if (context instanceof AbstractSpan) {
                ((AbstractSpan)context).deactivate();
            }
        }
    }
}

