/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.concurrent;

import co.elastic.apm.agent.bci.TracerAwareInstrumentation;
import co.elastic.apm.agent.concurrent.JavaConcurrent;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.ForkJoinTask;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class ForkJoinTaskInstrumentation
extends TracerAwareInstrumentation {
    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.is(ForkJoinTask.class);
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("fork").and(ElementMatchers.returns(ForkJoinTask.class));
    }

    @Override
    public Collection<String> getInstrumentationGroupNames() {
        return Arrays.asList("concurrent", "fork-join");
    }

    static {
        if (Boolean.parseBoolean(System.getProperty("intellij.debug.agent"))) {
            throw new IllegalStateException("InteliJ debug agent detected, disable it to prevent unexpected instrumentation errors. See https://github.com/elastic/apm-agent-java/issues/1673");
        }
    }

    public static class AdviceClass {
        @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
        public static void onExecute(@Advice.This ForkJoinTask<?> thiz) {
            JavaConcurrent.withContext(thiz, TracerAwareInstrumentation.tracer);
        }

        @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class, inline=false)
        public static void onExit(@Nullable @Advice.Thrown Throwable thrown, @Advice.This ForkJoinTask<?> thiz) {
            JavaConcurrent.doFinally(thrown, thiz);
        }
    }
}

