/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.collections;

import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;

public class SpanConcurrentHashMap<K, V extends AbstractSpan<?>>
extends ConcurrentHashMap<K, V> {
    SpanConcurrentHashMap() {
    }

    @Override
    @Nullable
    public V remove(Object key) {
        AbstractSpan removed = (AbstractSpan)super.remove(key);
        this.onRemove(removed);
        return (V)removed;
    }

    @Override
    public V put(K key, V value) {
        AbstractSpan previous = (AbstractSpan)super.put(key, value);
        this.onPut(previous, (AbstractSpan<?>)value);
        return (V)previous;
    }

    @Override
    public V putIfAbsent(K key, V value) {
        AbstractSpan previous = (AbstractSpan)super.putIfAbsent(key, value);
        if (previous == null) {
            this.onPut(null, (AbstractSpan<?>)value);
        }
        return (V)previous;
    }

    @Override
    public void clear() {
        Iterator entries = this.values().iterator();
        while (entries.hasNext()) {
            this.onRemove((AbstractSpan)entries.next());
        }
        super.clear();
    }

    private void onPut(@Nullable AbstractSpan<?> previous, AbstractSpan<?> value) {
        if (previous == null) {
            value.incrementReferences();
        } else if (previous != value) {
            value.incrementReferences();
            previous.decrementReferences();
        }
    }

    private void onRemove(@Nullable AbstractSpan<?> removed) {
        if (removed == null) {
            return;
        }
        removed.decrementReferences();
    }
}

