/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.collections;

import co.elastic.apm.agent.collections.NullCheck;
import co.elastic.apm.agent.sdk.weakconcurrent.DetachedThreadLocal;
import co.elastic.apm.agent.sdk.weakconcurrent.WeakMap;
import javax.annotation.Nullable;

public class DetachedThreadLocalImpl<T>
implements DetachedThreadLocal<T> {
    private final WeakMap<Thread, T> map;

    DetachedThreadLocalImpl(WeakMap<Thread, T> map) {
        this.map = map;
    }

    @Override
    @Nullable
    public T get() {
        return this.map.get(Thread.currentThread());
    }

    @Override
    @Nullable
    public T getAndRemove() {
        T value = this.get();
        if (value != null) {
            this.remove();
        }
        return value;
    }

    @Override
    public void set(@Nullable T value) {
        if (NullCheck.isNullKey(value)) {
            return;
        }
        this.map.put(Thread.currentThread(), value);
    }

    @Override
    public void remove() {
        this.map.remove(Thread.currentThread());
    }
}

