/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.cassandra3;

import co.elastic.apm.agent.bci.TracerAwareInstrumentation;
import co.elastic.apm.agent.bci.bytebuddy.CustomElementMatchers;
import co.elastic.apm.agent.cassandra.CassandraHelper;
import co.elastic.apm.agent.impl.GlobalTracer;
import co.elastic.apm.agent.impl.transaction.Span;
import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class Cassandra3Instrumentation
extends TracerAwareInstrumentation {
    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.named("com.datastax.driver.core.SessionManager");
    }

    @Override
    public ElementMatcher.Junction<ClassLoader> getClassLoaderMatcher() {
        return CustomElementMatchers.classLoaderCanLoadClass("com.datastax.driver.core.BoundStatement");
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("executeAsync").and(ElementMatchers.returns(ElementMatchers.named("com.datastax.driver.core.ResultSetFuture"))).and(ElementMatchers.takesArgument(0, ElementMatchers.named("com.datastax.driver.core.Statement")));
    }

    @Override
    public Collection<String> getInstrumentationGroupNames() {
        return Collections.singletonList("cassandra");
    }

    @Override
    public String getAdviceClassName() {
        return "co.elastic.apm.agent.cassandra3.Cassandra3Instrumentation$Cassandra3Advice";
    }

    private static interface DestinationAddressSetter {
        public void setDestination(Span var1, Host var2);

        public static enum WithInetAddress implements DestinationAddressSetter
        {
            INSTANCE;


            @Override
            public void setDestination(Span span, Host host) {
                span.getContext().getDestination().withInetAddress(host.getAddress());
            }
        }

        public static enum WithSocketAddress implements DestinationAddressSetter
        {
            INSTANCE;


            @Override
            public void setDestination(Span span, Host host) {
                span.getContext().getDestination().withSocketAddress(host.getSocketAddress());
            }
        }

        public static class Resolver {
            @Nullable
            private static volatile DestinationAddressSetter delegate;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            static DestinationAddressSetter get() {
                DestinationAddressSetter localDelegate = delegate;
                if (localDelegate != null) return localDelegate;
                Class<Resolver> clazz = Resolver.class;
                synchronized (Resolver.class) {
                    localDelegate = delegate;
                    if (localDelegate != null) return localDelegate;
                    try {
                        Class.forName("com.datastax.driver.core.Host").getMethod("getSocketAddress", new Class[0]);
                        delegate = localDelegate = (DestinationAddressSetter)Class.forName(DestinationAddressSetter.class.getName() + "$WithSocketAddress").getEnumConstants()[0];
                    }
                    catch (LinkageError | ReflectiveOperationException ignore) {
                        delegate = localDelegate = WithInetAddress.INSTANCE;
                    }
                    return localDelegate;
                }
            }
        }
    }

    public static class Cassandra3Advice {
        private static final CassandraHelper cassandraHelper = new CassandraHelper(GlobalTracer.get());

        @Nullable
        @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
        public static Object onEnter(@Advice.Argument(value=0) Statement statement) {
            return cassandraHelper.startCassandraSpan(Cassandra3Advice.getQuery(statement), statement instanceof BoundStatement);
        }

        @Nullable
        private static String getQuery(Statement statement) {
            if (statement instanceof SimpleStatement) {
                return ((SimpleStatement)statement).getQueryString();
            }
            if (statement instanceof BoundStatement) {
                return ((BoundStatement)statement).preparedStatement().getQueryString();
            }
            return null;
        }

        @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class, inline=false)
        public static void onExit(@Advice.Thrown @Nullable Throwable thrown, @Advice.Return ResultSetFuture result, @Nullable @Advice.Enter Object spanObj) {
            if (!(spanObj instanceof Span)) {
                return;
            }
            final Span span = (Span)spanObj;
            ((Span)span.captureException(thrown)).deactivate();
            Futures.addCallback((ListenableFuture)result, (FutureCallback)new FutureCallback<ResultSet>(){

                public void onSuccess(@Nullable ResultSet result) {
                    Host host;
                    if (result != null && (host = result.getExecutionInfo().getQueriedHost()) != null) {
                        DestinationAddressSetter.Resolver.get().setDestination(span, host);
                    }
                    span.end();
                }

                public void onFailure(Throwable t) {
                    span.endExceptionally(t);
                }
            });
        }
    }
}

