/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.bci.classloading;

import co.elastic.apm.agent.sdk.ElasticApmInstrumentation;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ExternalPluginClassLoader
extends URLClassLoader {
    private final List<String> classNames;

    public ExternalPluginClassLoader(File pluginJar, ClassLoader agentClassLoader) throws IOException {
        super(new URL[]{pluginJar.toURI().toURL()}, agentClassLoader);
        this.classNames = Collections.unmodifiableList(this.scanForClasses(pluginJar));
        if (this.classNames.contains(ElasticApmInstrumentation.class.getName())) {
            throw new IllegalStateException("The plugin %s contains the plugin SDK. Please make sure the scope for the dependency apm-agent-plugin-sdk is set to provided.");
        }
    }

    private List<String> scanForClasses(File pluginJar) throws IOException {
        ArrayList<String> tempClassNames = new ArrayList<String>();
        try (JarFile jarFile = new JarFile(pluginJar);){
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry jarEntry = entries.nextElement();
                if (!jarEntry.getName().endsWith(".class")) continue;
                tempClassNames.add(jarEntry.getName().replace('/', '.').substring(0, jarEntry.getName().length() - 6));
            }
        }
        return tempClassNames;
    }

    public List<String> getClassNames() {
        return this.classNames;
    }
}

