/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.bci.classloading;

import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import net.bytebuddy.matcher.ElementMatcher;

class DiscriminatingMultiParentClassLoader
extends ClassLoader {
    private static final String CLASS_EXTENSION = ".class";
    private final List<ClassLoader> parents;
    private final List<ElementMatcher<String>> discriminators;

    DiscriminatingMultiParentClassLoader(ClassLoader agentClassLoader, ElementMatcher<String> classesToLoadFromAgentClassLoader, ClassLoader targetClassLoader, ElementMatcher<String> classesToLoadFromTargetClassLoader) throws NullPointerException {
        super(targetClassLoader);
        if (agentClassLoader == null || targetClassLoader == null) {
            throw new NullPointerException("The bootstrap class loader cannot be used as one of this class loader parents. Use a single-parent class loader instead.");
        }
        this.parents = Arrays.asList(agentClassLoader, targetClassLoader);
        this.discriminators = Arrays.asList(classesToLoadFromAgentClassLoader, classesToLoadFromTargetClassLoader);
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            int parentsSize = this.parents.size();
            for (int i = 0; i < parentsSize; ++i) {
                ClassLoader parent = this.parents.get(i);
                ElementMatcher<String> discriminator = this.discriminators.get(i);
                if (!discriminator.matches(name)) continue;
                try {
                    Class<?> type = parent.loadClass(name);
                    if (resolve) {
                        this.resolveClass(type);
                    }
                    return type;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            throw new ClassNotFoundException(name);
        }
    }

    @Override
    public URL getResource(String name) {
        String className = null;
        if (name.endsWith(CLASS_EXTENSION)) {
            className = name.replace('/', '.').substring(0, name.length() - CLASS_EXTENSION.length());
        }
        int parentsSize = this.parents.size();
        for (int i = 0; i < parentsSize; ++i) {
            URL url;
            ClassLoader parent = this.parents.get(i);
            ElementMatcher<String> discriminator = this.discriminators.get(i);
            if (className != null && !discriminator.matches(className) || (url = parent.getResource(name)) == null) continue;
            return url;
        }
        return null;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        String className = null;
        if (name.endsWith(CLASS_EXTENSION)) {
            className = name.replace('/', '.').substring(0, name.length() - CLASS_EXTENSION.length());
        }
        int parentsSize = this.parents.size();
        for (int i = 0; i < parentsSize; ++i) {
            Enumeration<URL> resources;
            ClassLoader parent = this.parents.get(i);
            ElementMatcher<String> discriminator = this.discriminators.get(i);
            if (className != null && !discriminator.matches(className) || !(resources = parent.getResources(name)).hasMoreElements()) continue;
            return resources;
        }
        return Collections.emptyEnumeration();
    }

    static {
        DiscriminatingMultiParentClassLoader.registerAsParallelCapable();
    }
}

