/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.bci;

import co.elastic.apm.agent.bci.ElasticApmAgent;
import co.elastic.apm.agent.bci.bytebuddy.MatcherTimer;
import co.elastic.apm.agent.context.AbstractLifecycleListener;
import java.util.ArrayList;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MatcherTimerLifecycleListener
extends AbstractLifecycleListener {
    private static final Logger logger = LoggerFactory.getLogger(MatcherTimerLifecycleListener.class);

    @Override
    public void stop() {
        if (logger.isDebugEnabled()) {
            ArrayList<MatcherTimer> matcherTimers = new ArrayList<MatcherTimer>(ElasticApmAgent.getMatcherTimers());
            Collections.sort(matcherTimers);
            StringBuilder sb = new StringBuilder().append("Total time spent matching: ").append(String.format("%,d", ElasticApmAgent.getTotalMatcherTime())).append("ns").append('\n').append(MatcherTimer.getTableHeader()).append('\n');
            for (MatcherTimer matcherTimer : matcherTimers) {
                sb.append(matcherTimer.toString()).append('\n');
            }
            logger.debug(sb.toString());
        }
    }
}

